"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionLink = TransactionLink;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _get_redirect_to_transaction_detail_page_url = require("../trace_link/get_redirect_to_transaction_detail_page_url");
var _use_apm_params = require("../../../hooks/use_apm_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CentralizedContainer = _common.euiStyled.div`
  height: 100%;
  display: flex;
`;
function TransactionLink() {
  const {
    path: {
      transactionId
    },
    query: {
      rangeFrom,
      rangeTo,
      waterfallItemId
    }
  } = (0, _use_apm_params.useApmParams)('/link-to/transaction/{transactionId}');
  const {
    data = {
      transaction: null
    },
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (transactionId) {
      return callApmApi('GET /internal/apm/transactions/{transactionId}', {
        params: {
          path: {
            transactionId
          }
        }
      });
    }
  }, [transactionId]);
  if (transactionId && status === _use_fetcher.FETCH_STATUS.SUCCESS) {
    if (data.transaction) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: (0, _get_redirect_to_transaction_detail_page_url.getRedirectToTransactionDetailPageUrl)({
          transaction: data.transaction,
          rangeFrom,
          rangeTo,
          waterfallItemId
        })
      });
    }
    return /*#__PURE__*/_react.default.createElement(CentralizedContainer, null);
  }
  return /*#__PURE__*/_react.default.createElement(CentralizedContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "apmTrace",
    title: /*#__PURE__*/_react.default.createElement("h2", null, "Fetching transaction...")
  }));
}