"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallFlyout = WaterfallFlyout;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_apm_params = require("../../../../../../hooks/use_apm_params");
var _span_flyout = require("./span_flyout");
var _transaction_flyout = require("./transaction_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function WaterfallFlyout({
  waterfallItemId,
  waterfall,
  toggleFlyout
}) {
  var _currentItem$parent, _waterfall$rootWaterf;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    query: {
      flyoutDetailTab
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view', '/traces/explorer/waterfall', '/dependencies/operation');
  const currentItem = waterfall.items.find(item => item.id === waterfallItemId);
  if (!currentItem) {
    return null;
  }
  switch (currentItem.docType) {
    case 'span':
      const parentTransactionId = ((_currentItem$parent = currentItem.parent) === null || _currentItem$parent === void 0 ? void 0 : _currentItem$parent.docType) === 'transaction' ? currentItem.parentId : undefined;
      return /*#__PURE__*/_react.default.createElement(_span_flyout.SpanFlyout, {
        totalDuration: waterfall.duration,
        spanId: currentItem.id,
        parentTransactionId: parentTransactionId,
        traceId: currentItem.doc.trace.id,
        onClose: () => toggleFlyout({
          history
        }),
        spanLinksCount: currentItem.spanLinksCount,
        flyoutDetailTab: flyoutDetailTab
      });
    case 'transaction':
      return /*#__PURE__*/_react.default.createElement(_transaction_flyout.TransactionFlyout, {
        transactionId: currentItem.id,
        traceId: currentItem.doc.trace.id,
        onClose: () => toggleFlyout({
          history
        }),
        rootTransactionDuration: (_waterfall$rootWaterf = waterfall.rootWaterfallTransaction) === null || _waterfall$rootWaterf === void 0 ? void 0 : _waterfall$rootWaterf.duration,
        errorCount: waterfall.getErrorCount(currentItem.id),
        spanLinksCount: currentItem.spanLinksCount,
        flyoutDetailTab: flyoutDetailTab
      });
    default:
      return null;
  }
}