"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionFlyout = TransactionFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _use_fetcher = require("../../../../../../../hooks/use_fetcher");
var _transaction_metadata = require("../../../../../../shared/metadata_table/transaction_metadata");
var _span_links_tab_content = require("../../../../../../shared/span_links/span_links_tab_content");
var _transaction_summary = require("../../../../../../shared/summary/transaction_summary");
var _transaction_action_menu = require("../../../../../../shared/transaction_action_menu/transaction_action_menu");
var _flyout_top_level_properties = require("../flyout_top_level_properties");
var _responsive_flyout = require("../responsive_flyout");
var _dropped_spans_warning = require("./dropped_spans_warning");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionFlyout({
  transactionId,
  traceId,
  onClose,
  errorCount = 0,
  rootTransactionDuration,
  spanLinksCount,
  flyoutDetailTab
}) {
  const {
    data: transaction,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/traces/{traceId}/transactions/{transactionId}', {
      params: {
        path: {
          traceId,
          transactionId
        }
      }
    });
  }, [traceId, transactionId]);
  const isLoading = (0, _use_fetcher.isPending)(status);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_responsive_flyout.ResponsiveFlyout, {
    onClose: onClose,
    ownFocus: true,
    maxWidth: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.apm.transactionDetails.transFlyout.transactionDetailsTitle', {
    defaultMessage: 'Transaction details'
  })))), transaction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_transaction_action_menu.TransactionActionMenu, {
    isLoading: false,
    transaction: transaction
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, null), transaction && /*#__PURE__*/_react.default.createElement(TransactionFlyoutBody, {
    transaction: transaction,
    errorCount: errorCount,
    rootTransactionDuration: rootTransactionDuration,
    spanLinksCount: spanLinksCount,
    flyoutDetailTab: flyoutDetailTab
  }))));
}
function TransactionFlyoutBody({
  transaction,
  errorCount,
  rootTransactionDuration,
  spanLinksCount,
  flyoutDetailTab
}) {
  var _tabs$find, _transaction$faas;
  const spanLinksTabContent = (0, _span_links_tab_content.getSpanLinksTabContent)({
    spanLinksCount,
    traceId: transaction.trace.id,
    spanId: transaction.transaction.id,
    processorEvent: _common.ProcessorEvent.transaction
  });
  const tabs = [{
    id: 'metadata',
    name: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.metadataLabel', {
      defaultMessage: 'Metadata'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_transaction_metadata.TransactionMetadata, {
      transactionId: transaction.transaction.id
    }))
  }, ...(spanLinksTabContent ? [spanLinksTabContent] : [])];
  const initialTab = (_tabs$find = tabs.find(({
    id
  }) => id === flyoutDetailTab)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_top_level_properties.FlyoutTopLevelProperties, {
    transaction: transaction
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_transaction_summary.TransactionSummary, {
    transaction: transaction,
    totalDuration: rootTransactionDuration,
    errorCount: errorCount,
    coldStartBadge: (_transaction$faas = transaction.faas) === null || _transaction$faas === void 0 ? void 0 : _transaction$faas.coldstart
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_dropped_spans_warning.DroppedSpansWarning, {
    transactionDoc: transaction
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    initialSelectedTab: initialTab,
    tabs: tabs
  }));
}