"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StickySpanProperties = StickySpanProperties;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _apm = require("../../../../../../../../common/es_fields/apm");
var _environment_filter_values = require("../../../../../../../../common/environment_filter_values");
var _i18n2 = require("../../../../../../../../common/i18n");
var _use_apm_params = require("../../../../../../../hooks/use_apm_params");
var _dependency_link = require("../../../../../../shared/links/dependency_link");
var _transaction_detail_link = require("../../../../../../shared/links/apm/transaction_detail_link");
var _service_link = require("../../../../../../shared/links/apm/service_link");
var _sticky_properties = require("../../../../../../shared/sticky_properties");
var _latency_aggregation_types = require("../../../../../../../../common/latency_aggregation_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StickySpanProperties({
  span,
  transaction
}) {
  var _span$span$destinatio;
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view', '/traces/explorer', '/dependencies/operation');
  const {
    environment,
    comparisonEnabled,
    offset
  } = query;
  const latencyAggregationType = 'latencyAggregationType' in query && query.latencyAggregationType || _latency_aggregation_types.LatencyAggregationType.avg;
  const serviceGroup = 'serviceGroup' in query && query.serviceGroup || '';
  const trackEvent = (0, _public.useUiTracker)();
  const nextEnvironment = (0, _environment_filter_values.getNextEnvironmentUrlParam)({
    requestedEnvironment: transaction === null || transaction === void 0 ? void 0 : transaction.service.environment,
    currentEnvironmentUrlParam: environment
  });
  const spanName = span.span.name;
  const dependencyName = (_span$span$destinatio = span.span.destination) === null || _span$span$destinatio === void 0 ? void 0 : _span$span$destinatio.service.resource;
  const transactionStickyProperties = transaction ? [{
    label: _i18n.i18n.translate('xpack.apm.transactionDetails.serviceLabel', {
      defaultMessage: 'Service'
    }),
    fieldName: _apm.SERVICE_NAME,
    val: /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
      agentName: transaction.agent.name,
      query: {
        ...query,
        serviceGroup,
        environment: nextEnvironment
      },
      serviceName: transaction.service.name
    }),
    width: '25%'
  }, {
    label: _i18n.i18n.translate('xpack.apm.transactionDetails.transactionLabel', {
      defaultMessage: 'Transaction'
    }),
    fieldName: _apm.TRANSACTION_NAME,
    val: /*#__PURE__*/_react.default.createElement(_transaction_detail_link.TransactionDetailLink, {
      serviceName: transaction.service.name,
      transactionId: transaction.transaction.id,
      traceId: transaction.trace.id,
      transactionName: transaction.transaction.name,
      transactionType: transaction.transaction.type,
      environment: nextEnvironment,
      latencyAggregationType: latencyAggregationType,
      comparisonEnabled: comparisonEnabled,
      offset: offset
    }, transaction.transaction.name),
    width: '25%'
  }] : [];
  const dependencyStickyProperties = dependencyName ? [{
    label: _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.dependencyLabel', {
      defaultMessage: 'Dependency'
    }),
    fieldName: _apm.SPAN_DESTINATION_SERVICE_RESOURCE,
    val: /*#__PURE__*/_react.default.createElement(_dependency_link.DependencyLink, {
      query: {
        ...query,
        dependencyName
      },
      subtype: span.span.subtype,
      type: span.span.type,
      onClick: () => {
        trackEvent({
          app: 'apm',
          metricType: _public.METRIC_TYPE.CLICK,
          metric: 'span_flyout_to_dependency_detail'
        });
      }
    }),
    width: '25%'
  }] : [];
  const stickyProperties = [{
    label: _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.nameLabel', {
      defaultMessage: 'Name'
    }),
    fieldName: _apm.SPAN_NAME,
    val: spanName !== null && spanName !== void 0 ? spanName : _i18n2.NOT_AVAILABLE_LABEL,
    truncated: true,
    width: '25%'
  }, ...dependencyStickyProperties, ...transactionStickyProperties];
  return /*#__PURE__*/_react.default.createElement(_sticky_properties.StickyProperties, {
    stickyProperties: stickyProperties
  });
}