"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanFlyout = SpanFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _common2 = require("@kbn/observability-plugin/common");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../../../../../../hooks/use_fetcher");
var _discover_span_link = require("../../../../../../shared/links/discover_links/discover_span_link");
var _span_metadata = require("../../../../../../shared/metadata_table/span_metadata");
var _span_links_tab_content = require("../../../../../../shared/span_links/span_links_tab_content");
var _stacktrace = require("../../../../../../shared/stacktrace");
var _summary = require("../../../../../../shared/summary");
var _composite_span_duration_summary_item = require("../../../../../../shared/summary/composite_span_duration_summary_item");
var _duration_summary_item = require("../../../../../../shared/summary/duration_summary_item");
var _http_info_summary_item = require("../../../../../../shared/summary/http_info_summary_item");
var _timestamp_tooltip = require("../../../../../../shared/timestamp_tooltip");
var _sync_badge = require("../badge/sync_badge");
var _failure_badge = require("../failure_badge");
var _responsive_flyout = require("../responsive_flyout");
var _span_db = require("./span_db");
var _sticky_span_properties = require("./sticky_span_properties");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatType(type) {
  switch (type) {
    case 'db':
      return 'DB';
    case 'hard-navigation':
      return _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanType.navigationTimingLabel', {
        defaultMessage: 'Navigation timing'
      });
    default:
      return type;
  }
}
function formatSubtype(subtype) {
  switch (subtype) {
    case 'mysql':
      return 'MySQL';
    default:
      return subtype;
  }
}
function getSpanTypes(span) {
  const {
    type,
    subtype,
    action
  } = span.span;
  return {
    spanType: formatType(type),
    spanSubtype: formatSubtype(subtype),
    spanAction: action
  };
}
const ContainerWithMarginRight = _common.euiStyled.div`
  /* add margin to all direct descendants */
  & > * {
    margin-right: ${({
  theme
}) => theme.eui.euiSizeXS};
  }
`;
const INITIAL_DATA = {
  span: undefined,
  parentTransaction: undefined
};
function SpanFlyout({
  spanId,
  parentTransactionId,
  traceId,
  totalDuration,
  onClose,
  spanLinksCount,
  flyoutDetailTab
}) {
  const {
    data = INITIAL_DATA,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/traces/{traceId}/spans/{spanId}', {
      params: {
        path: {
          traceId,
          spanId
        },
        query: {
          parentTransactionId
        }
      }
    });
  }, [traceId, spanId, parentTransactionId]);
  const {
    span,
    parentTransaction
  } = data;
  const isLoading = (0, _use_fetcher.isPending)(status);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_responsive_flyout.ResponsiveFlyout, {
    onClose: onClose,
    size: "m",
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanDetailsTitle', {
    defaultMessage: 'Span details'
  })))), span && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_discover_span_link.DiscoverSpanLink, {
    spanId: span.span.id
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.viewSpanInDiscoverButtonLabel', {
    defaultMessage: 'View span in Discover'
  })))), (span === null || span === void 0 ? void 0 : span.span.composite) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "gear",
    size: "s"
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.compositeExampleWarning', {
    defaultMessage: 'This is a sample document for a group of consecutive, similar spans'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, null), span && /*#__PURE__*/_react.default.createElement(SpanFlyoutBody, {
    span: span,
    parentTransaction: parentTransaction,
    totalDuration: totalDuration,
    spanLinksCount: spanLinksCount,
    flyoutDetailTab: flyoutDetailTab
  }))));
}
function SpanFlyoutBody({
  span,
  parentTransaction,
  totalDuration,
  spanLinksCount,
  flyoutDetailTab
}) {
  var _parentTransaction$se, _span$http, _span$http$response, _span$span, _span$span$http, _span$span$http$respo, _span$url, _span$span2, _span$span2$http, _span$span2$http$url, _span$http2, _span$http2$request, _span$span3, _span$span3$http, _tabs$find, _span$event;
  const stackframes = span.span.stacktrace;
  const codeLanguage = parentTransaction === null || parentTransaction === void 0 ? void 0 : (_parentTransaction$se = parentTransaction.service.language) === null || _parentTransaction$se === void 0 ? void 0 : _parentTransaction$se.name;
  const spanDb = span.span.db;
  const spanTypes = getSpanTypes(span);
  const spanHttpStatusCode = ((_span$http = span.http) === null || _span$http === void 0 ? void 0 : (_span$http$response = _span$http.response) === null || _span$http$response === void 0 ? void 0 : _span$http$response.status_code) || ((_span$span = span.span) === null || _span$span === void 0 ? void 0 : (_span$span$http = _span$span.http) === null || _span$span$http === void 0 ? void 0 : (_span$span$http$respo = _span$span$http.response) === null || _span$span$http$respo === void 0 ? void 0 : _span$span$http$respo.status_code);
  const spanHttpUrl = ((_span$url = span.url) === null || _span$url === void 0 ? void 0 : _span$url.original) || ((_span$span2 = span.span) === null || _span$span2 === void 0 ? void 0 : (_span$span2$http = _span$span2.http) === null || _span$span2$http === void 0 ? void 0 : (_span$span2$http$url = _span$span2$http.url) === null || _span$span2$http$url === void 0 ? void 0 : _span$span2$http$url.original);
  const spanHttpMethod = ((_span$http2 = span.http) === null || _span$http2 === void 0 ? void 0 : (_span$http2$request = _span$http2.request) === null || _span$http2$request === void 0 ? void 0 : _span$http2$request.method) || ((_span$span3 = span.span) === null || _span$span3 === void 0 ? void 0 : (_span$span3$http = _span$span3.http) === null || _span$span3$http === void 0 ? void 0 : _span$span3$http.method);
  const spanLinksTabContent = (0, _span_links_tab_content.getSpanLinksTabContent)({
    spanLinksCount,
    traceId: span.trace.id,
    spanId: span.span.id,
    processorEvent: _common2.ProcessorEvent.span
  });
  const tabs = [{
    id: 'metadata',
    name: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.metadataLabel', {
      defaultMessage: 'Metadata'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_span_metadata.SpanMetadata, {
      spanId: span.span.id
    }))
  }, ...(!(0, _lodash.isEmpty)(stackframes) ? [{
    id: 'stack-trace',
    name: _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.stackTraceTabLabel', {
      defaultMessage: 'Stack Trace'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_stacktrace.Stacktrace, {
      stackframes: stackframes,
      codeLanguage: codeLanguage
    }))
  }] : []), ...(spanLinksTabContent ? [spanLinksTabContent] : [])];
  const initialTab = (_tabs$find = tabs.find(({
    id
  }) => id === flyoutDetailTab)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sticky_span_properties.StickySpanProperties, {
    span: span,
    transaction: parentTransaction
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_summary.Summary, {
    items: [/*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
      time: span.timestamp.us / 1000
    }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_duration_summary_item.DurationSummaryItem, {
      duration: span.span.duration.us,
      totalDuration: totalDuration,
      parentType: "transaction"
    }), span.span.composite && /*#__PURE__*/_react.default.createElement(_composite_span_duration_summary_item.CompositeSpanDurationSummaryItem, {
      count: span.span.composite.count,
      durationSum: span.span.composite.sum.us
    })), /*#__PURE__*/_react.default.createElement(ContainerWithMarginRight, null, spanHttpUrl && /*#__PURE__*/_react.default.createElement(_http_info_summary_item.HttpInfoSummaryItem, {
      method: spanHttpMethod,
      url: spanHttpUrl,
      status: spanHttpStatusCode
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanType', {
        defaultMessage: 'Type'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, spanTypes.spanType)), spanTypes.spanSubtype && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanSubtype', {
        defaultMessage: 'Subtype'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, spanTypes.spanSubtype)), spanTypes.spanAction && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanAction', {
        defaultMessage: 'Action'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, spanTypes.spanAction)), /*#__PURE__*/_react.default.createElement(_failure_badge.FailureBadge, {
      outcome: (_span$event = span.event) === null || _span$event === void 0 ? void 0 : _span$event.outcome
    }), /*#__PURE__*/_react.default.createElement(_sync_badge.SyncBadge, {
      sync: span.span.sync,
      agentName: span.agent.name
    }))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_span_db.SpanDatabase, {
    spanDb: spanDb
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: initialTab
  }));
}