"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaybeViewTraceLink = MaybeViewTraceLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _transaction_detail_link = require("../../../shared/links/apm/transaction_detail_link");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _latency_aggregation_types = require("../../../../../common/latency_aggregation_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FullTraceButton({
  isLoading,
  isDisabled
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmFullTraceButtonViewFullTraceButton",
    fill: true,
    iconType: "apmTrace",
    isLoading: isLoading,
    disabled: isDisabled
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.viewFullTraceButtonLabel', {
    defaultMessage: 'View full trace'
  }));
}
function MaybeViewTraceLink({
  isLoading,
  transaction,
  waterfall,
  environment
}) {
  const {
    query,
    query: {
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view', '/traces/explorer', '/dependencies/operation');
  const latencyAggregationType = 'latencyAggregationType' in query && query.latencyAggregationType || _latency_aggregation_types.LatencyAggregationType.avg;
  if (isLoading || !transaction) {
    return /*#__PURE__*/_react.default.createElement(FullTraceButton, {
      isLoading: isLoading
    });
  }
  const {
    rootWaterfallTransaction
  } = waterfall;
  // the traceroot cannot be found, so we cannot link to it
  if (!rootWaterfallTransaction) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.transactionDetails.noTraceParentButtonTooltip', {
        defaultMessage: 'The trace parent cannot be found'
      })
    }, /*#__PURE__*/_react.default.createElement(FullTraceButton, {
      isDisabled: true
    }));
  }
  const rootTransaction = rootWaterfallTransaction.doc;
  const isRoot = transaction.transaction.id === rootWaterfallTransaction.id;

  // the user is already viewing the full trace, so don't link to it
  if (isRoot) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.transactionDetails.viewingFullTraceButtonTooltip', {
        defaultMessage: 'Currently viewing the full trace'
      })
    }, /*#__PURE__*/_react.default.createElement(FullTraceButton, {
      isDisabled: true
    }));

    // the user is viewing a zoomed in version of the trace. Link to the full trace
  } else {
    const nextEnvironment = (0, _environment_filter_values.getNextEnvironmentUrlParam)({
      requestedEnvironment: rootTransaction.service.environment,
      currentEnvironmentUrlParam: environment
    });
    return /*#__PURE__*/_react.default.createElement(_transaction_detail_link.TransactionDetailLink, {
      serviceName: rootTransaction.service.name,
      transactionId: rootTransaction.transaction.id,
      traceId: rootTransaction.trace.id,
      transactionName: rootTransaction.transaction.name,
      transactionType: rootTransaction.transaction.type,
      environment: nextEnvironment,
      latencyAggregationType: latencyAggregationType,
      comparisonEnabled: comparisonEnabled,
      offset: offset
    }, /*#__PURE__*/_react.default.createElement(FullTraceButton, null));
  }
}