"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceSearchBox = TraceSearchBox;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-search-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _trace_explorer = require("../../../../../common/trace_explorer");
var _use_apm_data_view = require("../../../../hooks/use_apm_data_view");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _constants = require("../../../shared/eql_code_editor/constants");
var _lazily_loaded_code_editor = require("../../../shared/eql_code_editor/lazily_loaded_code_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = [{
  value: _trace_explorer.TraceSearchType.kql,
  text: _i18n.i18n.translate('xpack.apm.traceSearchBox.traceSearchTypeKql', {
    defaultMessage: 'KQL'
  })
}, {
  value: _trace_explorer.TraceSearchType.eql,
  text: _i18n.i18n.translate('xpack.apm.traceSearchBox.traceSearchTypeEql', {
    defaultMessage: 'EQL'
  })
}];
function TraceSearchBox({
  query,
  onQueryChange,
  onQueryCommit,
  message,
  error,
  loading
}) {
  const {
    unifiedSearch,
    core,
    data,
    dataViews
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    notifications,
    http,
    docLinks,
    uiSettings
  } = core;
  const {
    services: {
      storage
    }
  } = (0, _public2.useKibana)();
  const {
    dataView
  } = (0, _use_apm_data_view.useApmDataView)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, query.type === _trace_explorer.TraceSearchType.eql ? /*#__PURE__*/_react.default.createElement(_lazily_loaded_code_editor.LazilyLoadedEQLCodeEditor, {
    value: query.query,
    onChange: value => {
      onQueryChange({
        ...query,
        query: value
      });
    },
    onBlur: () => {
      onQueryCommit();
    },
    getSuggestions: async request => {
      var _dataView$fields$map;
      switch (request.type) {
        case _constants.EQLCodeEditorSuggestionType.EventType:
          return ['transaction', 'span', 'error'];
        case _constants.EQLCodeEditorSuggestionType.Field:
          return (_dataView$fields$map = dataView === null || dataView === void 0 ? void 0 : dataView.fields.map(field => field.name)) !== null && _dataView$fields$map !== void 0 ? _dataView$fields$map : [];
        case _constants.EQLCodeEditorSuggestionType.Value:
          const field = dataView === null || dataView === void 0 ? void 0 : dataView.getFieldByName(request.field);
          if (!dataView || !field) {
            return [];
          }
          const suggestions = await unifiedSearch.autocomplete.getValueSuggestions({
            field,
            indexPattern: dataView,
            query: request.value,
            useTimeRange: true,
            method: 'terms_agg'
          });
          return suggestions.slice(0, 15);
      }
    },
    width: "100%",
    height: "100px"
  }) : /*#__PURE__*/_react.default.createElement("form", null, /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
    disableLanguageSwitcher: true,
    indexPatterns: dataView ? [dataView] : [],
    query: {
      query: query.query,
      language: 'kuery'
    },
    onSubmit: () => {
      onQueryCommit();
    },
    disableAutoFocus: true,
    submitOnBlur: true,
    isClearable: true,
    onChange: e => {
      var _e$query;
      onQueryChange({
        ...query,
        query: String((_e$query = e.query) !== null && _e$query !== void 0 ? _e$query : '')
      });
    },
    appName: _i18n.i18n.translate('xpack.apm.traceExplorer.appName', {
      defaultMessage: 'APM'
    }),
    deps: {
      unifiedSearch,
      notifications,
      http,
      docLinks,
      uiSettings,
      data,
      dataViews,
      storage
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "apmTraceSearchBoxSelect",
    id: "select-query-language",
    value: query.type,
    onChange: e => {
      onQueryChange({
        query: '',
        type: e.target.value
      });
    },
    options: options
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: error ? 'danger' : 'subdued',
    size: "xs"
  }, message)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmTraceSearchBoxSearchButton",
    isLoading: loading,
    onClick: () => {
      onQueryCommit();
    },
    iconType: "search"
  }, _i18n.i18n.translate('xpack.apm.traceSearchBox.refreshButton', {
    defaultMessage: 'Search'
  }))))))));
}