"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceList = TraceList;
exports.getTraceListColumns = getTraceListColumns;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _formatters = require("../../../../common/utils/formatters");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _style = require("../../../utils/style");
var _empty_message = require("../../shared/empty_message");
var _impact_bar = require("../../shared/impact_bar");
var _transaction_detail_link = require("../../shared/links/apm/transaction_detail_link");
var _managed_table = require("../../shared/managed_table");
var _service_link = require("../../shared/links/apm/service_link");
var _truncate_with_tooltip = require("../../shared/truncate_with_tooltip");
var _i18n2 = require("../../../../common/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledTransactionLink = (0, _common.euiStyled)(_transaction_detail_link.TransactionDetailLink)`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
  ${(0, _style.truncate)('100%')};
`;
function getTraceListColumns({
  query
}) {
  return [{
    field: 'transactionName',
    name: _i18n.i18n.translate('xpack.apm.tracesTable.nameColumnLabel', {
      defaultMessage: 'Name'
    }),
    width: '40%',
    sortable: true,
    render: (_, {
      serviceName,
      transactionName,
      transactionType
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: transactionName,
      anchorClassName: "eui-textTruncate"
    }, /*#__PURE__*/_react.default.createElement(StyledTransactionLink, {
      serviceName: serviceName,
      transactionName: transactionName,
      transactionType: transactionType
    }, transactionName))
  }, {
    field: 'serviceName',
    name: _i18n.i18n.translate('xpack.apm.tracesTable.originatingServiceColumnLabel', {
      defaultMessage: 'Originating service'
    }),
    sortable: true,
    render: (_, {
      serviceName,
      agentName,
      transactionType
    }) => /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
      "data-test-subj": "apmTraceListAppLink",
      text: serviceName || _i18n2.NOT_AVAILABLE_LABEL,
      content: /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
        agentName: agentName,
        query: {
          ...query,
          transactionType,
          serviceGroup: ''
        },
        serviceName: serviceName
      })
    })
  }, {
    field: 'averageResponseTime',
    name: _i18n.i18n.translate('xpack.apm.tracesTable.avgResponseTimeColumnLabel', {
      defaultMessage: 'Latency (avg.)'
    }),
    sortable: true,
    dataType: 'number',
    render: (_, {
      averageResponseTime
    }) => (0, _formatters.asMillisecondDuration)(averageResponseTime)
  }, {
    field: 'transactionsPerMinute',
    name: _i18n.i18n.translate('xpack.apm.tracesTable.tracesPerMinuteColumnLabel', {
      defaultMessage: 'Traces per minute'
    }),
    sortable: true,
    dataType: 'number',
    render: (_, {
      transactionsPerMinute
    }) => (0, _formatters.asTransactionRate)(transactionsPerMinute)
  }, {
    field: 'impact',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.tracesTable.impactColumnDescription', {
        defaultMessage: 'The most used and slowest endpoints in your service. Calculated by multiplying latency by throughput.'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.tracesTable.impactColumnLabel', {
      defaultMessage: 'Impact'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    align: _eui.RIGHT_ALIGNMENT,
    sortable: true,
    render: (_, {
      impact
    }) => /*#__PURE__*/_react.default.createElement(_impact_bar.ImpactBar, {
      value: impact
    })
  }];
}
const noItemsMessage = /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, {
  heading: _i18n.i18n.translate('xpack.apm.tracesTable.notFoundLabel', {
    defaultMessage: 'No traces found for this query'
  })
});
function TraceList({
  response
}) {
  const {
    data: {
      items
    } = {
      items: []
    },
    status
  } = response;
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/traces');
  const traceListColumns = (0, _react.useMemo)(() => getTraceListColumns({
    query
  }), [query]);
  return /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
    error: status === _use_fetcher.FETCH_STATUS.FAILURE,
    columns: traceListColumns,
    items: items,
    initialSortField: "impact",
    initialSortDirection: "desc",
    noItemsMessage: noItemsMessage,
    initialPageSize: 25
  });
}