"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageExplorer = StorageExplorer;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _index_lifecycle_phase_select = require("./index_lifecycle_phase_select");
var _services_table = require("./services_table");
var _search_bar = require("../../shared/search_bar/search_bar");
var _storage_chart = require("./storage_chart");
var _permission_denied = require("./prompts/permission_denied");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _summary_stats = require("./summary_stats");
var _environment_filter = require("../../shared/environment_filter");
var _tips_and_resources = require("./resources/tips_and_resources");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _get_storage_explorer_links = require("./get_storage_explorer_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CALLOUT_DISMISS_INITIAL_STATE = {
  crossClusterSearch: false,
  optimizePerformance: false
};
const dismissButtonText = _i18n.i18n.translate('xpack.apm.storageExplorer.callout.dimissButton', {
  defaultMessage: 'Dismiss'
});
function StorageExplorer() {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const [calloutDismissed, setCalloutDismissed] = (0, _use_local_storage.useLocalStorage)('apm.storageExplorer.calloutDismissed', CALLOUT_DISMISS_INITIAL_STATE);
  const {
    data: hasPrivilegesData,
    status: hasPrivilegesStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/storage_explorer/privileges');
  }, []);
  const {
    data: isCrossClusterSearchData
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!calloutDismissed.crossClusterSearch) {
      return callApmApi('GET /internal/apm/storage_explorer/is_cross_cluster_search');
    }
  }, [calloutDismissed]);
  const loading = hasPrivilegesStatus === _use_fetcher.FETCH_STATUS.LOADING;
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl"
      }),
      titleSize: "xs",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.storageExplorer.loadingPromptTitle', {
        defaultMessage: 'Loading Storage Explorer...'
      }))
    });
  }
  if (!(hasPrivilegesData !== null && hasPrivilegesData !== void 0 && hasPrivilegesData.hasPrivileges)) {
    return /*#__PURE__*/_react.default.createElement(_permission_denied.PermissionDenied, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_environment_filter.ApmEnvironmentFilter, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_index_lifecycle_phase_select.IndexLifecyclePhaseSelect, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !calloutDismissed.optimizePerformance && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.storageExplorer.longLoadingTimeCalloutTitle', {
      defaultMessage: 'Long loading time?'
    }),
    iconType: "timeRefresh"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.storageExplorer.longLoadingTimeCalloutText",
    defaultMessage: "Enable progressive loading of data and optimized sorting for services list in {kibanaAdvancedSettingsLink}.",
    values: {
      kibanaAdvancedSettingsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmStorageExplorerKibanaAdvancedSettingsLink",
        href: (0, _get_storage_explorer_links.getKibanaAdvancedSettingsHref)(core)
      }, _i18n.i18n.translate('xpack.apm.storageExplorer.longLoadingTimeCalloutLink', {
        defaultMessage: 'Kibana advanced settings'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmStorageExplorerButton",
    onClick: () => setCalloutDismissed({
      ...calloutDismissed,
      optimizePerformance: true
    })
  }, dismissButtonText)), !calloutDismissed.crossClusterSearch && (isCrossClusterSearchData === null || isCrossClusterSearchData === void 0 ? void 0 : isCrossClusterSearchData.isCrossClusterSearch) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.storageExplorer.crossClusterSearchCalloutTitle', {
      defaultMessage: 'Searching across clusters?'
    }),
    iconType: "search"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.storageExplorer.crossClusterSearchCalloutText', {
    defaultMessage: 'While getting document count works with cross-cluster search, index statistics such as size are only displayed for data that are stored in this cluster.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmStorageExplorerButton",
    onClick: () => setCalloutDismissed({
      ...calloutDismissed,
      crossClusterSearch: true
    })
  }, dismissButtonText))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_summary_stats.SummaryStats, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_storage_chart.StorageChart, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_services_table.ServicesTable, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_tips_and_resources.TipsAndResources, null));
}