"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLinkOverview = CustomLinkOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _custom_link = require("../../../../../common/custom_link");
var _use_license_context = require("../../../../context/license/use_license_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _license_prompt = require("../../../shared/license_prompt");
var _create_custom_link_button = require("./create_custom_link_button");
var _create_edit_custom_link_flyout = require("./create_edit_custom_link_flyout");
var _custom_link_table = require("./custom_link_table");
var _empty_prompt = require("./empty_prompt");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomLinkOverview() {
  var _data$customLinks;
  const license = (0, _use_license_context.useLicenseContext)();
  const hasValidLicense = (license === null || license === void 0 ? void 0 : license.isActive) && (license === null || license === void 0 ? void 0 : license.hasAtLeast('gold'));
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const [customLinkSelected, setCustomLinkSelected] = (0, _react.useState)();
  const {
    data,
    status,
    refetch
  } = (0, _use_fetcher.useFetcher)(async callApmApi => {
    if (hasValidLicense) {
      return callApmApi('GET /internal/apm/settings/custom_links');
    }
  }, [hasValidLicense]);
  const customLinks = (_data$customLinks = data === null || data === void 0 ? void 0 : data.customLinks) !== null && _data$customLinks !== void 0 ? _data$customLinks : [];
  (0, _react.useEffect)(() => {
    if (customLinkSelected) {
      setIsFlyoutOpen(true);
    }
  }, [customLinkSelected]);
  const onCloseFlyout = () => {
    setCustomLinkSelected(undefined);
    setIsFlyoutOpen(false);
  };
  const onCreateCustomLinkClick = () => {
    setIsFlyoutOpen(true);
  };
  const showEmptyPrompt = status === _use_fetcher.FETCH_STATUS.SUCCESS && (0, _lodash.isEmpty)(customLinks);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFlyoutOpen && /*#__PURE__*/_react.default.createElement(_create_edit_custom_link_flyout.CreateEditCustomLinkFlyout, {
    onClose: onCloseFlyout,
    defaults: customLinkSelected,
    customLinkId: customLinkSelected === null || customLinkSelected === void 0 ? void 0 : customLinkSelected.id,
    onSave: () => {
      onCloseFlyout();
      refetch();
    },
    onDelete: () => {
      onCloseFlyout();
      refetch();
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.info', {
    defaultMessage: 'These links will be shown in the Actions context menu in selected areas of the app, e.g. by the transactions detail.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.settings.customLink', {
    defaultMessage: 'Custom Links'
  })))), hasValidLicense && !showEmptyPrompt && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_create_custom_link_button.CreateCustomLinkButton, {
    onClick: onCreateCustomLinkClick
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), hasValidLicense ? showEmptyPrompt ? /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    onCreateCustomLinkClick: onCreateCustomLinkClick
  }) : /*#__PURE__*/_react.default.createElement(_custom_link_table.CustomLinkTable, {
    items: customLinks,
    onCustomLinkSelected: setCustomLinkSelected
  }) : /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
    text: _custom_link.INVALID_LICENSE
  }));
}