"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = ConfirmDeleteModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _all_option = require("../../../../../../common/agent_configuration/all_option");
var _create_call_apm_api = require("../../../../../services/rest/create_call_apm_api");
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ConfirmDeleteModal({
  config,
  onCancel,
  onConfirm
}) {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.apm.agentConfig.deleteModal.title', {
      defaultMessage: `Delete configuration`
    }),
    onCancel: onCancel,
    onConfirm: async () => {
      setIsDeleting(true);
      await deleteConfig(config, toasts);
      setIsDeleting(false);
      onConfirm();
    },
    cancelButtonText: _i18n.i18n.translate('xpack.apm.agentConfig.deleteModal.cancel', {
      defaultMessage: `Cancel`
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.apm.agentConfig.deleteModal.confirm', {
      defaultMessage: `Delete`
    }),
    confirmButtonDisabled: isDeleting,
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.agentConfig.deleteModal.text', {
    defaultMessage: `You are about to delete the configuration for service "{serviceName}" and environment "{environment}".`,
    values: {
      serviceName: (0, _all_option.getOptionLabel)(config.service.name),
      environment: (0, _all_option.getOptionLabel)(config.service.environment)
    }
  })));
}
async function deleteConfig(config, toasts) {
  try {
    await (0, _create_call_apm_api.callApmApi)('DELETE /api/apm/settings/agent-configuration', {
      signal: null,
      params: {
        body: {
          service: {
            name: config.service.name,
            environment: config.service.environment
          }
        }
      }
    });
    toasts.addSuccess({
      title: _i18n.i18n.translate('xpack.apm.agentConfig.deleteSection.deleteConfigSucceededTitle', {
        defaultMessage: 'Configuration was deleted'
      }),
      text: _i18n.i18n.translate('xpack.apm.agentConfig.deleteSection.deleteConfigSucceededText', {
        defaultMessage: 'You have successfully deleted a configuration for "{serviceName}". It will take some time to propagate to the agents.',
        values: {
          serviceName: (0, _all_option.getOptionLabel)(config.service.name)
        }
      })
    });
  } catch (error) {
    toasts.addDanger({
      title: _i18n.i18n.translate('xpack.apm.agentConfig.deleteSection.deleteConfigFailedTitle', {
        defaultMessage: 'Configuration could not be deleted'
      }),
      text: _i18n.i18n.translate('xpack.apm.agentConfig.deleteSection.deleteConfigFailedText', {
        defaultMessage: 'Something went wrong when deleting a configuration for "{serviceName}". Error: "{errorMessage}"',
        values: {
          serviceName: (0, _all_option.getOptionLabel)(config.service.name),
          errorMessage: error.message
        }
      })
    });
  }
}