"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingFormRow = SettingFormRow;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _setting_definitions = require("../../../../../../../common/agent_configuration/setting_definitions");
var _amount_and_unit = require("../../../../../../../common/agent_configuration/amount_and_unit");
var _select_with_placeholder = require("../../../../../shared/select_with_placeholder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FormRow({
  setting,
  value,
  onChange
}) {
  switch (setting.type) {
    case 'float':
    case 'text':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          "data-test-subj": "apmFormRowFieldText",
          placeholder: setting.placeholder,
          value: value || '',
          onChange: e => onChange(setting.key, e.target.value)
        });
      }
    case 'integer':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
          "data-test-subj": "apmFormRowFieldNumber",
          placeholder: setting.placeholder,
          value: value || '',
          min: setting.min,
          max: setting.max,
          onChange: e => onChange(setting.key, e.target.value)
        });
      }
    case 'select':
      {
        return /*#__PURE__*/_react.default.createElement(_select_with_placeholder.SelectWithPlaceholder, {
          placeholder: setting.placeholder,
          options: setting.options,
          value: value,
          onChange: e => onChange(setting.key, e.target.value)
        });
      }
    case 'boolean':
      {
        return /*#__PURE__*/_react.default.createElement(_select_with_placeholder.SelectWithPlaceholder, {
          placeholder: setting.placeholder,
          options: [{
            text: 'true',
            value: 'true'
          }, {
            text: 'false',
            value: 'false'
          }],
          value: value,
          onChange: e => onChange(setting.key, e.target.value)
        });
      }
    case 'bytes':
    case 'duration':
      {
        var _setting$units;
        const {
          amount,
          unit
        } = (0, _amount_and_unit.amountAndUnitToObject)(value !== null && value !== void 0 ? value : '');
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
          "data-test-subj": "apmFormRowFieldNumber",
          placeholder: setting.placeholder,
          value: amount,
          onChange: e => onChange(setting.key, (0, _amount_and_unit.amountAndUnitToString)({
            amount: e.target.value,
            unit
          }))
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_select_with_placeholder.SelectWithPlaceholder, {
          placeholder: _i18n.i18n.translate('xpack.apm.unitLabel', {
            defaultMessage: 'Select unit'
          }),
          value: unit,
          options: (_setting$units = setting.units) === null || _setting$units === void 0 ? void 0 : _setting$units.map(text => ({
            text,
            value: text
          })),
          onChange: e => onChange(setting.key, (0, _amount_and_unit.amountAndUnitToString)({
            amount,
            unit: e.target.value
          }))
        })));
      }
    default:
      throw new Error(`Unknown type "${setting.type}"`);
  }
}
function SettingFormRow({
  isUnsaved,
  setting,
  value,
  onChange
}) {
  const {
    isValid,
    message
  } = (0, _setting_definitions.validateSetting)(setting, value);
  const isInvalid = value != null && value !== '' && !isValid;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, setting.label, ' ', isUnsaved && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'dot',
      color: 'warning',
      content: _i18n.i18n.translate('xpack.apm.agentConfig.unsavedSetting.tooltip', {
        defaultMessage: 'Unsaved'
      })
    })),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, setting.description), setting.defaultValue && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "Default: ", setting.defaultValue)))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: setting.key,
    error: message,
    isInvalid: isInvalid
  }, /*#__PURE__*/_react.default.createElement(FormRow, {
    onChange: onChange,
    setting: setting,
    value: value
  })));
}