"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EdgeContents = EdgeContents;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _trace_explorer = require("../../../../../common/trace_explorer");
var _transaction_tabs = require("../../transaction_details/waterfall_with_summary/transaction_tabs");
var _apm = require("../../../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EdgeContents({
  elementData
}) {
  const edgeData = elementData;
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/service-map', '/services/{serviceName}/service-map', '/mobile-services/{serviceName}/service-map');
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const sourceService = edgeData.sourceData['service.name'];
  const trackEvent = (0, _public.useUiTracker)();
  let traceQuery;
  if (_apm.SERVICE_NAME in edgeData.targetData) {
    traceQuery = `sequence by trace.id\n` + ` [ span where service.name == "${sourceService}" and span.destination.service.resource != null ] by span.id\n` + ` [ transaction where service.name == "${edgeData.targetData[_apm.SERVICE_NAME]}" ] by parent.id`;
  } else {
    traceQuery = `sequence by trace.id\n` + ` [ transaction where service.name == "${sourceService}" ]\n` + ` [ span where service.name == "${sourceService}" and span.destination.service.resource == "${edgeData.targetData[_apm.SPAN_DESTINATION_SERVICE_RESOURCE]}" ]`;
  }
  const url = apmRouter.link('/traces/explorer/waterfall', {
    query: {
      ...query,
      type: _trace_explorer.TraceSearchType.eql,
      query: traceQuery,
      waterfallItemId: '',
      traceId: '',
      transactionId: '',
      detailTab: _transaction_tabs.TransactionTab.timeline,
      showCriticalPath: false
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmEdgeContentsExploreTracesButton",
    href: url,
    fill: true,
    onClick: () => {
      trackEvent({
        app: 'apm',
        metricType: _analytics.METRIC_TYPE.CLICK,
        metric: 'service_map_to_trace_explorer'
      });
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.viewInTraceExplorer', {
    defaultMessage: 'Explore traces'
  })));
}