"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceMap = ServiceMap;
exports.ServiceMapHome = ServiceMapHome;
exports.ServiceMapServiceDetail = ServiceMapServiceDetail;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _license_check = require("../../../../common/license_check");
var _service_map = require("../../../../common/service_map");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_license_context = require("../../../context/license/use_license_context");
var _use_theme = require("../../../hooks/use_theme");
var _license_prompt = require("../../shared/license_prompt");
var _controls = require("./controls");
var _cytoscape = require("./cytoscape");
var _cytoscape_options = require("./cytoscape_options");
var _empty_banner = require("./empty_banner");
var _empty_prompt = require("./empty_prompt");
var _popover = require("./popover");
var _timeout_prompt = require("./timeout_prompt");
var _use_ref_dimensions = require("./use_ref_dimensions");
var _search_bar = require("../../shared/search_bar/search_bar");
var _use_service_name = require("../../../hooks/use_service_name");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _disabled_prompt = require("./disabled_prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PromptContainer({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showUnifiedSearchBar: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround"
    // Set the height to give it some top margin
    ,
    style: {
      height: '60vh'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 600,
      textAlign: 'center'
    }
  }, children)));
}
function LoadingSpinner() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    style: {
      position: 'absolute',
      top: '50%',
      left: '50%'
    }
  });
}
function ServiceMapHome() {
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      serviceGroup
    }
  } = (0, _use_apm_params.useApmParams)('/service-map');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  return /*#__PURE__*/_react.default.createElement(ServiceMap, {
    environment: environment,
    kuery: kuery,
    start: start,
    end: end,
    serviceGroupId: serviceGroup
  });
}
function ServiceMapServiceDetail() {
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/service-map', '/mobile-services/{serviceName}/service-map');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  return /*#__PURE__*/_react.default.createElement(ServiceMap, {
    environment: environment,
    kuery: kuery,
    start: start,
    end: end
  });
}
function ServiceMap({
  environment,
  kuery,
  start,
  end,
  serviceGroupId
}) {
  var _error$body, _error$body2;
  const theme = (0, _use_theme.useTheme)();
  const license = (0, _use_license_context.useLicenseContext)();
  const serviceName = (0, _use_service_name.useServiceName)();
  const {
    config
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    data = {
      elements: []
    },
    status,
    error
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    // When we don't have a license or a valid license, don't make the request.
    if (!license || !(0, _license_check.isActivePlatinumLicense)(license) || !config.serviceMapEnabled) {
      return;
    }
    return callApmApi('GET /internal/apm/service-map', {
      isCachable: false,
      params: {
        query: {
          start,
          end,
          environment,
          serviceName,
          serviceGroup: serviceGroupId,
          kuery
        }
      }
    });
  }, [license, serviceName, environment, start, end, serviceGroupId, kuery, config.serviceMapEnabled]);
  const {
    ref,
    height
  } = (0, _use_ref_dimensions.useRefDimensions)();

  // Temporary hack to work around bottom padding introduced by EuiPage
  const PADDING_BOTTOM = 24;
  const heightWithPadding = height - PADDING_BOTTOM;
  if (!license) {
    return null;
  }
  if (!(0, _license_check.isActivePlatinumLicense)(license)) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, null, /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
      text: _service_map.invalidLicenseMessage
    }));
  }
  if (!config.serviceMapEnabled) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, null, /*#__PURE__*/_react.default.createElement(_disabled_prompt.DisabledPrompt, null));
  }
  if (status === _use_fetcher.FETCH_STATUS.SUCCESS && data.elements.length === 0) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, null, /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null));
  }
  if (status === _use_fetcher.FETCH_STATUS.FAILURE && error && 'body' in error && ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 500 && ((_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) === _service_map.SERVICE_MAP_TIMEOUT_ERROR) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, null, /*#__PURE__*/_react.default.createElement(_timeout_prompt.TimeoutPrompt, {
      isGlobalServiceMap: !serviceName
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showTimeComparison: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "ServiceMap",
    style: {
      height: heightWithPadding
    },
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_cytoscape.Cytoscape, {
    elements: data.elements,
    height: heightWithPadding,
    serviceName: serviceName,
    style: (0, _cytoscape_options.getCytoscapeDivStyle)(theme, status)
  }, /*#__PURE__*/_react.default.createElement(_controls.Controls, null), serviceName && /*#__PURE__*/_react.default.createElement(_empty_banner.EmptyBanner, null), status === _use_fetcher.FETCH_STATUS.LOADING && /*#__PURE__*/_react.default.createElement(LoadingSpinner, null), /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    focusedServiceName: serviceName,
    environment: environment,
    kuery: kuery,
    start: start,
    end: end
  })))));
}