"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyBanner = EmptyBanner;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _cytoscape = require("./cytoscape");
var _use_theme = require("../../../hooks/use_theme");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyBannerContainer = _common.euiStyled.div`
  margin: ${({
  theme
}) => theme.eui.euiSizeS};
  /* Add some extra margin so it displays to the right of the controls. */
  left: calc(
    ${({
  theme
}) => theme.eui.euiSizeXXL} +
      ${({
  theme
}) => theme.eui.euiSizeS}
  );
  position: absolute;
  z-index: 1;
`;
function EmptyBanner() {
  const theme = (0, _use_theme.useTheme)();
  const cy = (0, _react.useContext)(_cytoscape.CytoscapeContext);
  const [nodeCount, setNodeCount] = (0, _react.useState)(0);
  const {
    docLinks
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  (0, _react.useEffect)(() => {
    const handler = event => setNodeCount(event.cy.nodes().length);
    if (cy) {
      cy.on('add remove', 'node', handler);
    }
    return () => {
      if (cy) {
        cy.removeListener('add remove', 'node', handler);
      }
    };
  }, [cy]);

  // Only show if there's a single node.
  if (!cy || nodeCount !== 1) {
    return null;
  }

  // Since we're absolutely positioned, we need to get the full width and
  // subtract the space for controls and margins.
  const width = cy.width() - parseInt(theme.eui.euiSizeXXL, 10) - parseInt(theme.eui.euiSizeL, 10);
  return /*#__PURE__*/_react.default.createElement(EmptyBannerContainer, {
    style: {
      width
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.serviceMap.emptyBanner.title', {
      defaultMessage: "Looks like there's only a single service."
    })
  }, _i18n.i18n.translate('xpack.apm.serviceMap.emptyBanner.message', {
    defaultMessage: "We will map out connected services and external requests if we can detect them. Please make sure you're running the latest version of the APM agent."
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmEmptyBannerLearnMoreInTheDocsLink",
    href: docLinks.links.apm.supportedServiceMaps
  }, _i18n.i18n.translate('xpack.apm.serviceMap.emptyBanner.docsLink', {
    defaultMessage: 'Learn more in the docs'
  }))));
}