"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupsList = ServiceGroupsList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _service_groups_list = require("./service_groups_list");
var _sort = require("./sort");
var _refresh_service_groups_subscriber = require("../refresh_service_groups_subscriber");
var _service_group_save = require("../service_group_save");
var _beta_badge = require("../../../shared/beta_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceGroupsList() {
  const [filter, setFilter] = (0, _react.useState)('');
  const [apmServiceGroupsSortType, setServiceGroupsSortType] = (0, _react.useState)('recently_added');
  const {
    data = {
      serviceGroups: []
    },
    status,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApmApi => callApmApi('GET /internal/apm/service-groups'), []);
  const {
    serviceGroups
  } = data;
  const {
    data: servicesGroupCounts = {},
    status: statsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceGroups.length) {
      return callApmApi('GET /internal/apm/service-group/counts');
    }
  }, [serviceGroups.length]);
  const isLoading = (0, _use_fetcher.isPending)(status);
  const isLoadingStats = (0, _use_fetcher.isPending)(statsStatus);
  const filteredItems = (0, _lodash.isEmpty)(filter) ? serviceGroups : serviceGroups.filter(item => item.groupName.toLowerCase().includes(filter.toLowerCase()));
  const sortedItems = (0, _lodash.sortBy)(filteredItems, item => apmServiceGroupsSortType === 'alphabetical' ? item.groupName.toLowerCase() : item.updatedAt);
  const items = apmServiceGroupsSortType === 'recently_added' ? sortedItems.reverse() : sortedItems;
  const clearFilterCallback = (0, _react.useCallback)(() => {
    setFilter('');
  }, []);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoObservability",
        size: "xl"
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.servicesGroups.loadingServiceGroups', {
        defaultMessage: 'Loading service groups'
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_refresh_service_groups_subscriber.RefreshServiceGroupsSubscriber, {
    onRefresh: refetch
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    fullWidth: true,
    clear: !(0, _lodash.isEmpty)(filter) ? {
      onClick: clearFilterCallback
    } : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "apmServiceGroupsListFieldText",
    icon: "search",
    fullWidth: true,
    value: filter,
    onChange: e => setFilter(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.apm.servicesGroups.filter', {
      defaultMessage: 'Filter groups'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sort.Sort, {
    type: apmServiceGroupsSortType,
    onChange: setServiceGroupsSortType
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m"
  }, serviceGroups.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      fontWeight: 'bold'
    },
    size: "s"
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.groupsCount', {
    defaultMessage: '{servicesCount} {servicesCount, plural, =0 {groups} one {group} other {groups}}',
    values: {
      servicesCount: filteredItems.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.listDescription', {
    defaultMessage: 'Displayed service counts reflect the last 24 hours.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_service_group_save.ServiceGroupSaveButton, null))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmServiceGroupsListGiveFeedbackLink",
    href: "https://ela.st/feedback-service-groups",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.beta.feedback.link', {
    defaultMessage: 'Give feedback'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, serviceGroups.length ? items.length ? /*#__PURE__*/_react.default.createElement(_service_groups_list.ServiceGroupsListItems, {
    items: items,
    serviceGroupCounts: servicesGroupCounts,
    isLoading: isLoadingStats
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "layers",
    iconColor: "black",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceGroups.filtered.emptyPrompt.serviceGroups', {
      defaultMessage: 'Service groups'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceGroups.filtered.emptyPrompt.message', {
      defaultMessage: 'No groups found for this filter'
    }))
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "addDataApp",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceGroups.data.emptyPrompt.noServiceGroups', {
      defaultMessage: 'No service groups'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceGroups.data.emptyPrompt.message', {
      defaultMessage: 'Start grouping and organising your services and your application. Learn more about Service groups or create a group.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_service_group_save.ServiceGroupSaveButton, null)
  }))))));
}