"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileStats = MobileStats;
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _use_apm_params = require("../../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _metric_item = require("./metric_item");
var _use_previous_period_text = require("../../../../../hooks/use_previous_period_text");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const valueFormatter = (value, suffix = '') => {
  return `${value} ${suffix}`;
};
function MobileStats({
  start,
  end,
  kuery
}) {
  var _data$currentPeriod$s, _data$currentPeriod, _data$currentPeriod$s2, _data$currentPeriod2, _data$currentPeriod2$, _data$previousPeriod$, _data$currentPeriod$r, _data$currentPeriod3, _data$currentPeriod3$, _data$previousPeriod$2, _data$currentPeriod4, _data$currentPeriod4$;
  const euiTheme = (0, _public.useTheme)();
  const {
    path: {
      serviceName
    },
    query: {
      environment,
      transactionType,
      offset,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/mobile-services/{serviceName}/overview');
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/mobile-services/{serviceName}/stats', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          environment,
          kuery,
          transactionType,
          offset
        }
      }
    });
  }, [start, end, environment, kuery, serviceName, transactionType, offset]);
  const getComparisonValueFormatter = (0, _react.useCallback)(value => {
    return /*#__PURE__*/_react.default.createElement("span", null, value && comparisonEnabled ? `${previousPeriodLabel}: ${value}` : null);
  }, [comparisonEnabled, previousPeriodLabel]);
  const getIcon = (0, _react.useCallback)(type => ({
    width = 20,
    height = 20,
    color
  }) => {
    return status === _use_fetcher.FETCH_STATUS.LOADING ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: type,
      width: width,
      height: height,
      fill: color
    });
  }, [status]);
  const loadingStats = (0, _use_fetcher.isPending)(status);
  const metrics = [{
    color: euiTheme.eui.euiColorDisabled,
    title: _i18n.i18n.translate('xpack.apm.mobile.metrics.crash.rate', {
      defaultMessage: 'Crash Rate (Crash per minute)'
    }),
    subtitle: _i18n.i18n.translate('xpack.apm.mobile.coming.soon', {
      defaultMessage: 'Coming Soon'
    }),
    icon: getIcon('bug'),
    value: 'N/A',
    valueFormatter: value => valueFormatter(value),
    trend: [],
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.eui.euiColorDisabled,
    title: _i18n.i18n.translate('xpack.apm.mobile.metrics.load.time', {
      defaultMessage: 'Slowest App load time'
    }),
    subtitle: _i18n.i18n.translate('xpack.apm.mobile.coming.soon', {
      defaultMessage: 'Coming Soon'
    }),
    icon: getIcon('visGauge'),
    value: 'N/A',
    valueFormatter: value => valueFormatter(value, 's'),
    trend: [],
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.eui.euiColorLightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.metrics.sessions', {
      defaultMessage: 'Sessions'
    }),
    icon: getIcon('timeslider'),
    value: (_data$currentPeriod$s = data === null || data === void 0 ? void 0 : (_data$currentPeriod = data.currentPeriod) === null || _data$currentPeriod === void 0 ? void 0 : (_data$currentPeriod$s2 = _data$currentPeriod.sessions) === null || _data$currentPeriod$s2 === void 0 ? void 0 : _data$currentPeriod$s2.value) !== null && _data$currentPeriod$s !== void 0 ? _data$currentPeriod$s : NaN,
    valueFormatter: value => valueFormatter(value),
    trend: data === null || data === void 0 ? void 0 : (_data$currentPeriod2 = data.currentPeriod) === null || _data$currentPeriod2 === void 0 ? void 0 : (_data$currentPeriod2$ = _data$currentPeriod2.sessions) === null || _data$currentPeriod2$ === void 0 ? void 0 : _data$currentPeriod2$.timeseries,
    extra: getComparisonValueFormatter(data === null || data === void 0 ? void 0 : (_data$previousPeriod$ = data.previousPeriod.sessions) === null || _data$previousPeriod$ === void 0 ? void 0 : _data$previousPeriod$.value),
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.eui.euiColorLightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.metrics.http.requests', {
      defaultMessage: 'HTTP requests'
    }),
    icon: getIcon('kubernetesPod'),
    value: (_data$currentPeriod$r = data === null || data === void 0 ? void 0 : (_data$currentPeriod3 = data.currentPeriod) === null || _data$currentPeriod3 === void 0 ? void 0 : (_data$currentPeriod3$ = _data$currentPeriod3.requests) === null || _data$currentPeriod3$ === void 0 ? void 0 : _data$currentPeriod3$.value) !== null && _data$currentPeriod$r !== void 0 ? _data$currentPeriod$r : NaN,
    extra: getComparisonValueFormatter(data === null || data === void 0 ? void 0 : (_data$previousPeriod$2 = data.previousPeriod.requests) === null || _data$previousPeriod$2 === void 0 ? void 0 : _data$previousPeriod$2.value),
    valueFormatter: value => valueFormatter(value),
    trend: data === null || data === void 0 ? void 0 : (_data$currentPeriod4 = data.currentPeriod) === null || _data$currentPeriod4 === void 0 ? void 0 : (_data$currentPeriod4$ = _data$currentPeriod4.requests) === null || _data$currentPeriod4$ === void 0 ? void 0 : _data$currentPeriod4$.timeseries,
    trendShape: _charts.MetricTrendShape.Area
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, metrics.map((metric, key) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: key
  }, /*#__PURE__*/_react.default.createElement(_metric_item.MetricItem, {
    id: key,
    data: [metric],
    isLoading: loadingStats
  }))));
}