"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileLocationStats = MobileLocationStats;
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _apm = require("../../../../../../common/es_fields/apm");
var _i18n2 = require("../../../../../../common/i18n");
var _metric_item = require("./metric_item");
var _use_previous_period_text = require("../../../../../hooks/use_previous_period_text");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIcon = type => ({
  width = 20,
  height = 20,
  color
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: type,
  width: width,
  height: height,
  fill: color
});
const formatDifference = value => {
  return value > 0 ? '+' + value.toFixed(0) + '%' : value.toFixed(0) + '%';
};
const calculateDiffPercentageAndFormat = (currentValue, previousValue) => {
  if (currentValue && previousValue) {
    const diffPercentageValue = (currentValue - previousValue) / previousValue * 100;
    return formatDifference(diffPercentageValue);
  }
  return 0;
};
function MobileLocationStats({
  start,
  end,
  kuery,
  serviceName,
  offset,
  environment,
  comparisonEnabled
}) {
  var _currentPeriod$mostRe, _currentPeriod$mostSe;
  const euiTheme = (0, _public.useTheme)();
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const locationField = _apm.CLIENT_GEO_COUNTRY_NAME;
  const {
    data: locationStatsData,
    status: locationStatsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/mobile-services/{serviceName}/location/stats', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          environment,
          kuery,
          locationField,
          offset
        }
      }
    });
  }, [start, end, environment, kuery, serviceName, locationField, offset]);
  const loadingLocationStats = (0, _use_fetcher.isPending)(locationStatsStatus);
  const currentPeriod = locationStatsData === null || locationStatsData === void 0 ? void 0 : locationStatsData.currentPeriod;
  const previousPeriod = locationStatsData === null || locationStatsData === void 0 ? void 0 : locationStatsData.previousPeriod;
  const getComparisonValueFormatter = (0, _react.useCallback)(({
    currentPeriodValue,
    previousPeriodValue
  }) => {
    const comparisonDiffValue = calculateDiffPercentageAndFormat(currentPeriodValue, previousPeriodValue);
    if (comparisonDiffValue && comparisonEnabled) {
      return /*#__PURE__*/_react.default.createElement("span", null, currentPeriodValue, " (", comparisonDiffValue, " ", previousPeriodLabel, ")");
    }
    return /*#__PURE__*/_react.default.createElement("span", null, currentPeriodValue ? `${currentPeriodValue}` : null);
  }, [comparisonEnabled, previousPeriodLabel]);
  const metrics = [{
    color: euiTheme.eui.euiColorLightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.location.metrics.http.requests.title', {
      defaultMessage: 'Most used in'
    }),
    extra: getComparisonValueFormatter({
      currentPeriodValue: currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostRequests.value,
      previousPeriodValue: previousPeriod === null || previousPeriod === void 0 ? void 0 : previousPeriod.mostRequests.value
    }),
    icon: getIcon('visBarHorizontal'),
    value: (_currentPeriod$mostRe = currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostRequests.location) !== null && _currentPeriod$mostRe !== void 0 ? _currentPeriod$mostRe : _i18n2.NOT_AVAILABLE_LABEL,
    valueFormatter: value => `${value}`,
    trend: currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostRequests.timeseries,
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.eui.euiColorDisabled,
    title: _i18n.i18n.translate('xpack.apm.mobile.location.metrics.crashes', {
      defaultMessage: 'Most crashes'
    }),
    subtitle: _i18n.i18n.translate('xpack.apm.mobile.coming.soon', {
      defaultMessage: 'Coming Soon'
    }),
    icon: getIcon('bug'),
    value: _i18n2.NOT_AVAILABLE_LABEL,
    valueFormatter: value => `${value}`,
    trend: [],
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.eui.euiColorLightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.location.metrics.sessions', {
      defaultMessage: 'Most sessions'
    }),
    extra: getComparisonValueFormatter({
      currentPeriodValue: currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostSessions.value,
      previousPeriodValue: previousPeriod === null || previousPeriod === void 0 ? void 0 : previousPeriod.mostSessions.value
    }),
    icon: getIcon('timeslider'),
    value: (_currentPeriod$mostSe = currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostSessions.location) !== null && _currentPeriod$mostSe !== void 0 ? _currentPeriod$mostSe : _i18n2.NOT_AVAILABLE_LABEL,
    valueFormatter: value => `${value}`,
    trend: currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostSessions.timeseries,
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.eui.euiColorDisabled,
    title: _i18n.i18n.translate('xpack.apm.mobile.location.metrics.launches', {
      defaultMessage: 'Most launches'
    }),
    subtitle: _i18n.i18n.translate('xpack.apm.mobile.coming.soon', {
      defaultMessage: 'Coming Soon'
    }),
    icon: getIcon('launch'),
    value: _i18n2.NOT_AVAILABLE_LABEL,
    valueFormatter: value => `${value}`,
    trend: [],
    trendShape: _charts.MetricTrendShape.Area
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, metrics.map((metric, key) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: key
  }, /*#__PURE__*/_react.default.createElement(_metric_item.MetricItem, {
    id: key,
    data: [metric],
    isLoading: loadingLocationStats
  }))));
}