"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PalleteColors = void 0;
exports.getLayerStyle = getLayerStyle;
var _common = require("@kbn/maps-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let PalleteColors;
exports.PalleteColors = PalleteColors;
(function (PalleteColors) {
  PalleteColors["BluetoRed"] = "Blue to Red";
  PalleteColors["YellowtoRed"] = "Yellow to Red";
})(PalleteColors || (exports.PalleteColors = PalleteColors = {}));
function getLayerStyle(fieldName, color) {
  return {
    type: 'VECTOR',
    properties: {
      icon: {
        type: _common.STYLE_TYPE.STATIC,
        options: {
          value: 'marker'
        }
      },
      fillColor: {
        type: _common.STYLE_TYPE.DYNAMIC,
        options: {
          color,
          colorCategory: 'palette_0',
          fieldMetaOptions: {
            isEnabled: true,
            sigma: 3
          },
          type: _common.COLOR_MAP_TYPE.ORDINAL,
          field: {
            name: fieldName,
            origin: _common.FIELD_ORIGIN.JOIN
          },
          useCustomColorRamp: false
        }
      },
      lineColor: {
        type: _common.STYLE_TYPE.DYNAMIC,
        options: {
          color: '#3d3d3d',
          fieldMetaOptions: {
            isEnabled: true
          }
        }
      },
      lineWidth: {
        type: _common.STYLE_TYPE.STATIC,
        options: {
          size: 1
        }
      },
      iconSize: {
        type: _common.STYLE_TYPE.STATIC,
        options: {
          size: 6
        }
      },
      iconOrientation: {
        type: _common.STYLE_TYPE.STATIC,
        options: {
          orientation: 0
        }
      },
      labelText: {
        type: _common.STYLE_TYPE.DYNAMIC,
        options: {
          field: {
            name: fieldName,
            origin: _common.FIELD_ORIGIN.JOIN
          }
        }
      },
      labelPosition: {
        options: {
          position: _common.LABEL_POSITIONS.CENTER
        }
      },
      labelZoomRange: {
        options: {
          useLayerZoomRange: true,
          minZoom: 0,
          maxZoom: 24
        }
      },
      labelColor: {
        type: _common.STYLE_TYPE.STATIC,
        options: {
          color: '#3d3d3d'
        }
      },
      labelSize: {
        type: _common.STYLE_TYPE.STATIC,
        options: {
          size: 14
        }
      },
      labelBorderColor: {
        type: _common.STYLE_TYPE.STATIC,
        options: {
          color: '#FFFFFF'
        }
      },
      symbolizeAs: {
        options: {
          value: _common.SYMBOLIZE_AS_TYPES.CIRCLE
        }
      },
      labelBorderSize: {
        options: {
          size: _common.LABEL_BORDER_SIZES.SMALL
        }
      }
    },
    isTimeAware: true
  };
}