"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileFilters = MobileFilters;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_time_range = require("../../../../../hooks/use_time_range");
var _use_apm_service_context = require("../../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../../hooks/use_apm_params");
var _use_breakpoints = require("../../../../../hooks/use_breakpoints");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _url_helpers = require("../../../../shared/links/url_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALL_OPTION = {
  value: 'all',
  text: 'All'
};
const MOBILE_FILTERS = [{
  key: 'device',
  label: _i18n.i18n.translate('xpack.apm.mobile.filters.device', {
    defaultMessage: 'Device'
  })
}, {
  key: 'osVersion',
  label: _i18n.i18n.translate('xpack.apm.mobile.filters.osVersion', {
    defaultMessage: 'OS version'
  })
}, {
  key: 'appVersion',
  label: _i18n.i18n.translate('xpack.apm.mobile.filters.appVersion', {
    defaultMessage: 'App version'
  })
}, {
  key: 'netConnectionType',
  label: _i18n.i18n.translate('xpack.apm.mobile.filters.nct', {
    defaultMessage: 'NCT'
  })
}];
function MobileFilters() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    isSmall,
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      netConnectionType,
      device,
      osVersion,
      appVersion,
      transactionType
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/mobile-services/{serviceName}/overview', '/mobile-services/{serviceName}/transactions', '/mobile-services/{serviceName}/transactions/view');
  const filters = {
    netConnectionType,
    device,
    osVersion,
    appVersion
  };
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data = {
      mobileFilters: []
    },
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/services/{serviceName}/mobile/filters', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          environment,
          kuery,
          transactionType
        }
      }
    });
  }, [start, end, environment, kuery, serviceName, transactionType]);
  function toSelectOptions(items) {
    return [ALL_OPTION, ...((items === null || items === void 0 ? void 0 : items.map(item => ({
      value: item,
      text: item
    }))) || [])];
  }
  function onChangeFilter(key, value) {
    (0, _url_helpers.push)(history, {
      query: {
        [key]: value === ALL_OPTION.value ? '' : value
      }
    });
  }
  const groupDirection = isLarge ? 'column' : 'row';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    responsive: false,
    direction: groupDirection
  }, MOBILE_FILTERS.map(({
    key,
    label
  }) => {
    var _data$mobileFilters$f, _data$mobileFilters$f2;
    const selectOptions = (_data$mobileFilters$f = data === null || data === void 0 ? void 0 : (_data$mobileFilters$f2 = data.mobileFilters.find(filter => filter.key === key)) === null || _data$mobileFilters$f2 === void 0 ? void 0 : _data$mobileFilters$f2.options) !== null && _data$mobileFilters$f !== void 0 ? _data$mobileFilters$f : [];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: key,
      style: isLarge ? {} : {
        width: '225px'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "apmMobileFiltersSelect",
      fullWidth: isSmall,
      isLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
      prepend: label,
      options: toSelectOptions(selectOptions),
      value: filters === null || filters === void 0 ? void 0 : filters[key],
      onChange: e => {
        onChangeFilter(key, e.target.value);
      }
    }));
  }));
}