"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpPopover = HelpPopover;
exports.HelpPopoverButton = HelpPopoverButton;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverContent = (0, _common.euiStyled)(_eui.EuiText)`
  max-width: 480px;
  max-height: 40vh;
`;
function HelpPopoverButton({
  buttonTextEnabled = false,
  onClick
}) {
  const buttonText = _i18n.i18n.translate('xpack.apm.helpPopover.ariaLabel', {
    defaultMessage: 'Help'
  });
  if (buttonTextEnabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "apmHelpPopoverButtonButton",
      className: "apmHelpPopover__buttonIcon",
      size: "s",
      iconType: "help",
      "aria-label": buttonText,
      onClick: onClick
    }, buttonText);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "apmHelpPopover__buttonIcon",
    size: "s",
    iconType: "help",
    "aria-label": buttonText,
    onClick: onClick
  });
}
function HelpPopover({
  anchorPosition,
  button,
  children,
  closePopover,
  isOpen,
  title
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: anchorPosition,
    button: button,
    closePopover: closePopover,
    isOpen: isOpen,
    panelPaddingSize: "s",
    ownFocus: true
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, title), /*#__PURE__*/_react.default.createElement(PopoverContent, {
    size: "s"
  }, children));
}