"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopErroneousTransactions = TopErroneousTransactions;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _spark_plot = require("../../../shared/charts/spark_plot");
var _get_timeseries_color = require("../../../shared/charts/helper/get_timeseries_color");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _transaction_detail_link = require("../../../shared/links/apm/transaction_detail_link");
var _truncate_with_tooltip = require("../../../shared/truncate_with_tooltip");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _formatters = require("../../../../../common/utils/formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_STATE = {
  topErroneousTransactions: []
};
function TopErroneousTransactions({
  serviceName
}) {
  const {
    query,
    path: {
      groupId
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/errors/{groupId}');
  const {
    rangeFrom,
    rangeTo,
    environment,
    kuery,
    offset,
    comparisonEnabled
  } = query;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data = INITIAL_STATE,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end) {
      return callApmApi('GET /internal/apm/services/{serviceName}/errors/{groupId}/top_erroneous_transactions', {
        params: {
          path: {
            serviceName,
            groupId
          },
          query: {
            environment,
            kuery,
            start,
            end,
            numBuckets: 20,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end, groupId, comparisonEnabled, offset]);
  const loading = (0, _use_fetcher.isPending)(status);
  const columns = [{
    field: 'transactionName',
    width: '60%',
    name: _i18n.i18n.translate('xpack.apm.errorGroupTopTransactions.column.transactionName', {
      defaultMessage: 'Transaction name'
    }),
    render: (_, {
      transactionName,
      transactionType
    }) => {
      return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
        text: transactionName,
        content: /*#__PURE__*/_react.default.createElement(_transaction_detail_link.TransactionDetailLink, {
          serviceName: serviceName,
          transactionName: transactionName,
          transactionType: transactionType !== null && transactionType !== void 0 ? transactionType : '',
          comparisonEnabled: comparisonEnabled,
          offset: offset
        }, transactionName)
      });
    }
  }, {
    field: 'occurrences',
    name: _i18n.i18n.translate('xpack.apm.errorGroupTopTransactions.column.occurrences', {
      defaultMessage: 'Error occurrences'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    dataType: 'number',
    render: (_, {
      occurrences,
      currentPeriodTimeseries,
      previousPeriodTimeseries
    }) => {
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.ERROR_OCCURRENCES);
      return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
        type: "bar",
        isLoading: loading,
        valueLabel: _i18n.i18n.translate('xpack.apm.errorGroupTopTransactions.column.occurrences.valueLabel', {
          defaultMessage: `{occurrences} occ.`,
          values: {
            occurrences: (0, _formatters.asInteger)(occurrences)
          }
        }),
        series: currentPeriodTimeseries,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimeseries : undefined,
        color: currentPeriodColor,
        comparisonSeriesColor: previousPeriodColor
      });
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.apm.errorGroupTopTransactions.title', {
    defaultMessage: 'Top 5 affected transactions'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: data.topErroneousTransactions,
    columns: columns,
    loading: loading,
    "data-test-subj": "topErroneousTransactionsTable",
    error: status === _use_fetcher.FETCH_STATUS.FAILURE ? _i18n.i18n.translate('xpack.apm.errorGroupTopTransactions.errorMessage', {
      defaultMessage: 'Failed to fetch'
    }) : '',
    noItemsMessage: loading ? _i18n.i18n.translate('xpack.apm.errorGroupTopTransactions.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.errorGroupTopTransactions.noResults', {
      defaultMessage: 'No errors found associated with transactions'
    })
  }));
}