"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorSampler = ErrorSampler;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _url_helpers = require("../../../shared/links/url_helpers");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _error_sample_detail = require("./error_sample_detail");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ErrorSampler({
  errorSampleIds,
  errorSamplesFetchStatus,
  occurrencesCount
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    path: {
      groupId
    },
    query
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/errors/{groupId}');
  const {
    rangeFrom,
    rangeTo,
    environment,
    kuery,
    errorId
  } = query;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data: errorData,
    status: errorFetchStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end && errorId) {
      return callApmApi('GET /internal/apm/services/{serviceName}/errors/{groupId}/error/{errorId}', {
        params: {
          path: {
            serviceName,
            groupId,
            errorId
          },
          query: {
            environment,
            kuery,
            start,
            end
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end, groupId, errorId]);
  const onSampleClick = sample => {
    history.push({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(history.location.search),
        errorId: sample
      })
    });
  };
  const loadingErrorSamplesData = (0, _use_fetcher.isPending)(errorSamplesFetchStatus);
  if (loadingErrorSamplesData || !errorData) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        textAlign: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_error_sample_detail.ErrorSampleDetails, {
    onSampleClick: onSampleClick,
    errorSampleIds: errorSampleIds,
    errorSamplesFetchStatus: errorSamplesFetchStatus,
    errorData: errorData,
    errorFetchStatus: errorFetchStatus,
    occurrencesCount: occurrencesCount
  });
}