"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exceptionStacktraceTab = void 0;
exports.getTabs = getTabs;
exports.metadataTab = exports.logStacktraceTab = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logStacktraceTab = {
  key: 'log_stacktrace',
  label: _i18n.i18n.translate('xpack.apm.errorGroup.tabs.logStacktraceLabel', {
    defaultMessage: 'Log stack trace'
  })
};
exports.logStacktraceTab = logStacktraceTab;
const exceptionStacktraceTab = {
  key: 'exception_stacktrace',
  label: _i18n.i18n.translate('xpack.apm.errorGroup.tabs.exceptionStacktraceLabel', {
    defaultMessage: 'Exception stack trace'
  })
};
exports.exceptionStacktraceTab = exceptionStacktraceTab;
const metadataTab = {
  key: 'metadata',
  label: _i18n.i18n.translate('xpack.apm.errorGroup.tabs.metadataLabel', {
    defaultMessage: 'Metadata'
  })
};
exports.metadataTab = metadataTab;
function getTabs(error) {
  var _error$error$log;
  const hasLogStacktrace = !(0, _lodash.isEmpty)(error === null || error === void 0 ? void 0 : (_error$error$log = error.error.log) === null || _error$error$log === void 0 ? void 0 : _error$error$log.stacktrace);
  return [...(hasLogStacktrace ? [logStacktraceTab] : []), exceptionStacktraceTab, metadataTab];
}