"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependenciesDetailTable = DependenciesDetailTable;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _get_comparison_options = require("../../shared/time_comparison/get_comparison_options");
var _connections = require("../../../../common/connections");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _dependencies_table = require("../../shared/dependencies_table");
var _service_link = require("../../shared/links/apm/service_link");
var _use_time_range = require("../../../hooks/use_time_range");
var _get_comparison_enabled = require("../../shared/time_comparison/get_comparison_enabled");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DependenciesDetailTable() {
  var _data$services$map;
  const {
    query: {
      dependencyName,
      rangeFrom,
      rangeTo,
      kuery,
      environment,
      comparisonEnabled: urlComparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies/overview');
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const comparisonEnabled = (0, _get_comparison_enabled.getComparisonEnabled)({
    core,
    urlComparisonEnabled
  });
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/dependencies/upstream_services', {
      params: {
        query: {
          dependencyName,
          start,
          end,
          environment,
          numBuckets: 20,
          offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
          kuery
        }
      }
    });
  }, [start, end, environment, offset, dependencyName, kuery, comparisonEnabled]);
  const dependencies = (_data$services$map = data === null || data === void 0 ? void 0 : data.services.map(dependency => {
    const {
      location
    } = dependency;
    const name = (0, _connections.getNodeName)(location);
    if (location.type !== _connections.NodeType.service) {
      throw new Error('Expected a service node');
    }
    return {
      name,
      currentStats: dependency.currentStats,
      previousStats: dependency.previousStats,
      link: /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
        serviceName: location.serviceName,
        agentName: location.agentName,
        query: {
          comparisonEnabled,
          offset,
          environment,
          kuery,
          rangeFrom,
          rangeTo,
          latencyAggregationType: undefined,
          transactionType: undefined,
          serviceGroup: ''
        }
      })
    };
  })) !== null && _data$services$map !== void 0 ? _data$services$map : [];
  return /*#__PURE__*/_react.default.createElement(_dependencies_table.DependenciesTable, {
    dependencies: dependencies,
    title: _i18n.i18n.translate('xpack.apm.dependencyDetail.dependenciesTableTitle', {
      defaultMessage: 'Upstream services'
    }),
    nameColumnTitle: _i18n.i18n.translate('xpack.apm.dependencyDetail.dependenciesTableColumn', {
      defaultMessage: 'Service'
    }),
    status: status,
    compact: false,
    initialPageSize: 25
  });
}