"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependenciesInventory = DependenciesInventory;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _dependencies = require("../../../../common/dependencies");
var _search_bar = require("../../shared/search_bar/search_bar");
var _dependencies_inventory_table = require("./dependencies_inventory_table");
var _use_apm_params = require("../../../hooks/use_apm_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DependenciesInventory() {
  const {
    query: {
      environment
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies/inventory');
  const searchBarBoolFilter = (0, _dependencies.getSearchBarBoolFilter)({
    environment
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showTimeComparison: true,
    searchBarPlaceholder: _dependencies.unifiedSearchBarPlaceholder,
    searchBarBoolFilter: searchBarBoolFilter
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_dependencies_inventory_table.DependenciesInventoryTable, null));
}