"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Breadcrumb = void 0;
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_breadcrumb = require("../../../context/breadcrumbs/use_breadcrumb");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Breadcrumb = ({
  title,
  href,
  children
}) => {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  (0, _use_breadcrumb.useBreadcrumb)(() => ({
    title,
    href: core.http.basePath.prepend('/app/apm' + href)
  }), [core.http.basePath, href, title]);
  return children;
};
exports.Breadcrumb = Breadcrumb;