"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntervalAndTimeRange = getIntervalAndTimeRange;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUCKET_SIZE = 20;
function getIntervalAndTimeRange({
  windowSize,
  windowUnit
}) {
  const end = Date.now();
  const start = end - _moment.default.duration(windowSize, windowUnit).asMilliseconds() * BUCKET_SIZE;
  return {
    interval: `${windowSize}${windowUnit}`,
    start: new Date(start).toISOString(),
    end: new Date(end).toISOString()
  };
}