"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertingCapabilities = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertingCapabilities = (plugins, capabilities) => {
  const canReadAlerts = !!capabilities.apm['alerting:show'];
  const canSaveAlerts = !!capabilities.apm['alerting:save'];
  const isAlertingPluginEnabled = !!plugins.alerting;
  const isAlertingAvailable = isAlertingPluginEnabled && (canReadAlerts || canSaveAlerts);
  return {
    isAlertingAvailable,
    canReadAlerts,
    canSaveAlerts
  };
};
exports.getAlertingCapabilities = getAlertingCapabilities;