"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPreview = ChartPreview;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_theme = require("../../../../hooks/use_theme");
var _timezone = require("../../../shared/charts/helper/timezone");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChartPreview({
  yTickFormat,
  threshold,
  uiSettings,
  series
}) {
  const [yMax, setYMax] = (0, _react.useState)(threshold);
  const theme = (0, _use_theme.useTheme)();
  const thresholdOpacity = 0.3;
  const timestamps = series.flatMap(({
    data
  }) => data.map(({
    x
  }) => x));
  const xMin = Math.min(...timestamps);
  const xMax = Math.max(...timestamps);
  const xFormatter = (0, _charts.niceTimeFormatter)([xMin, xMax]);
  function updateYMax() {
    // Make the maximum Y value either the actual max or 20% more than the threshold
    const values = series.flatMap(({
      data
    }) => data.map(d => {
      var _d$y;
      return (_d$y = d.y) !== null && _d$y !== void 0 ? _d$y : 0;
    }));
    setYMax(Math.max(...values, threshold * 1.2));
  }
  const style = {
    fill: theme.eui.euiColorVis2,
    line: {
      strokeWidth: 2,
      stroke: theme.eui.euiColorVis2,
      opacity: 1
    },
    opacity: thresholdOpacity
  };
  const rectDataValues = [{
    coordinates: {
      x0: null,
      x1: null,
      y0: threshold,
      y1: null
    }
  }];
  const timeZone = (0, _timezone.getTimeZone)(uiSettings);
  const legendSize = Math.ceil(series.length / 2) * 30;
  const chartSize = 150;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: series.length > 1 ? chartSize + legendSize : chartSize
    },
    "data-test-subj": "ChartPreview"
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    tooltip: "none",
    showLegend: series.length > 1,
    legendPosition: 'bottom',
    legendSize: legendSize,
    onLegendItemClick: updateYMax
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    dataValues: [{
      dataValue: threshold
    }],
    domainType: _charts.AnnotationDomainType.YDomain,
    id: "chart_preview_line_annotation",
    markerPosition: "left",
    style: style
  }), /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: rectDataValues,
    hideTooltips: true,
    id: "chart_preview_rect_annotation",
    style: style
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "chart_preview_x_axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: xFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "chart_preview_y_axis",
    position: _charts.Position.Left,
    tickFormat: yTickFormat,
    ticks: 5,
    domain: {
      max: yMax,
      min: 0
    }
  }), series.map(({
    name,
    data
  }, index) => /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    key: index,
    timeZone: timeZone,
    data: data,
    id: `chart_preview_bar_series_${name || index}`,
    name: name,
    xAccessor: "x",
    xScaleType: _charts.ScaleType.Time,
    yAccessors: ['y'],
    yScaleType: _charts.ScaleType.Linear
  }))));
}