"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _latency_chart = require("../../../../shared/charts/latency_chart");
var _timeseries_chart = require("../../../../shared/charts/timeseries_chart");
var _helper = require("../../../../shared/charts/transaction_charts/helper");
var _get_comparison_options = require("../../../../shared/time_comparison/get_comparison_options");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _latency_chart_selectors = require("../../../../../selectors/latency_chart_selectors");
var _helpers = require("../helpers");
var _alert_active_rect = require("./alert_active_rect");
var _alert_annotation = require("./alert_annotation");
var _alert_threshold_annotation = require("./alert_threshold_annotation");
var _alert_threshold_rect = require("./alert_threshold_rect");
var _document_type = require("../../../../../../common/document_type");
var _use_preferred_data_source_and_bucket_size = require("../../../../../hooks/use_preferred_data_source_and_bucket_size");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LatencyChart({
  alert,
  transactionType,
  serviceName,
  environment,
  start,
  end,
  latencyAggregationType,
  comparisonChartTheme,
  comparisonEnabled,
  offset,
  timeZone
}) {
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery: '',
    numBuckets: 100,
    type: _document_type.ApmDocumentType.ServiceTransactionMetric
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && start && end && transactionType && latencyAggregationType && preferred) {
      return callApmApi(`GET /internal/apm/services/{serviceName}/transactions/charts/latency`, {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery: '',
            start,
            end,
            transactionType,
            transactionName: undefined,
            latencyAggregationType,
            documentType: preferred.source.documentType,
            rollupInterval: preferred.source.rollupInterval,
            bucketSizeInSeconds: preferred.bucketSizeInSeconds
          }
        }
      });
    }
  }, [end, environment, latencyAggregationType, serviceName, start, transactionType, preferred]);
  const getLatencyChartAdditionalData = () => {
    if ((0, _helpers.isLatencyThresholdRuleType)(alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID])) {
      return [/*#__PURE__*/_react.default.createElement(_alert_threshold_rect.AlertThresholdRect, {
        key: 'alertThresholdRect',
        threshold: alert.fields[_ruleDataUtils.ALERT_EVALUATION_THRESHOLD],
        alertStarted: alert.start
      }), /*#__PURE__*/_react.default.createElement(_alert_annotation.AlertAnnotation, {
        key: 'alertAnnotationStart',
        alertStarted: alert.start
      }), /*#__PURE__*/_react.default.createElement(_alert_active_rect.AlertActiveRect, {
        key: 'alertAnnotationActiveRect',
        alertStarted: alert.start
      }), /*#__PURE__*/_react.default.createElement(_alert_threshold_annotation.AlertThresholdAnnotation, {
        key: 'alertThresholdAnnotation',
        threshold: alert.fields[_ruleDataUtils.ALERT_EVALUATION_THRESHOLD]
      })];
    }
  };
  const memoizedData = (0, _react.useMemo)(() => (0, _latency_chart_selectors.getLatencyChartSelector)({
    latencyChart: data,
    latencyAggregationType,
    previousPeriodLabel: ''
  }), [data, latencyAggregationType]);
  const {
    currentPeriod,
    previousPeriod
  } = memoizedData;
  const timeseriesLatency = [currentPeriod, comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriod : undefined].filter(_latency_chart.filterNil);
  const latencyMaxY = (0, _helper.getMaxY)(timeseriesLatency);
  const latencyFormatter = (0, _common.getDurationFormatter)(latencyMaxY);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.dependencyLatencyChart.chartTitle', {
    defaultMessage: 'Latency'
  }))))), /*#__PURE__*/_react.default.createElement(_timeseries_chart.TimeseriesChart, {
    id: "latencyChart",
    annotations: getLatencyChartAdditionalData(),
    height: 200,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    fetchStatus: status,
    customTheme: comparisonChartTheme,
    timeseries: timeseriesLatency,
    yLabelFormat: (0, _helper.getResponseTimeTickFormatter)(latencyFormatter),
    timeZone: timeZone
  })));
}

// eslint-disable-next-line import/no-default-export
var _default = LatencyChart;
exports.default = _default;
module.exports = exports.default;