"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertThresholdAnnotation = AlertThresholdAnnotation;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertThresholdAnnotation({
  threshold
}) {
  if (!threshold) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "annotation_alert_threshold",
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: [{
      dataValue: threshold,
      header: String(threshold)
    }],
    style: {
      line: {
        opacity: 0.5,
        strokeWidth: 1,
        stroke: _constants.CHART_ANNOTATION_RED_COLOR
      }
    }
  });
}