"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertAnnotation = AlertAnnotation;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertAnnotation({
  alertStarted
}) {
  return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "annotation_alert_started",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: [{
      dataValue: alertStarted,
      header: (0, _moment.default)(alertStarted).format(_constants.DEFAULT_DATE_FORMAT),
      details: _i18n.i18n.translate('xpack.apm.latency.chart.alertDetails.alertStarted', {
        defaultMessage: 'Alert started'
      })
    }],
    style: {
      line: {
        strokeWidth: 3,
        stroke: _constants.CHART_ANNOTATION_RED_COLOR,
        opacity: 1
      }
    },
    marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: _constants.CHART_ANNOTATION_RED_COLOR
    }),
    markerPosition: _charts.Position.Top
  });
}