"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertActiveRect = AlertActiveRect;
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertActiveRect({
  alertStarted
}) {
  return /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: "rect_alert_active",
    dataValues: [{
      coordinates: {
        y0: 0,
        x0: alertStarted
      },
      details: _i18n.i18n.translate('xpack.apm.latency.chart.alertDetails.active', {
        defaultMessage: 'Active'
      })
    }],
    style: {
      fill: 'red',
      opacity: 0.2
    }
  });
}