"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailsAppSection = AlertDetailsAppSection;
exports.default = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _public2 = require("@kbn/kibana-react-plugin/public");
var _apm = require("../../../../../common/es_fields/apm");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
var _time_range_metadata_context = require("../../../../context/time_range_metadata/time_range_metadata_context");
var _use_time_range = require("../../../../hooks/use_time_range");
var _get_comparison_chart_theme = require("../../../shared/time_comparison/get_comparison_chart_theme");
var _failed_transaction_chart = _interopRequireDefault(require("./failed_transaction_chart"));
var _helpers = require("./helpers");
var _latency_alerts_history_chart = require("./latency_alerts_history_chart");
var _latency_chart = _interopRequireDefault(require("./latency_chart/latency_chart"));
var _throughput_chart = _interopRequireDefault(require("./throughput_chart"));
var _types = require("./types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertDetailsAppSection({
  rule,
  alert,
  timeZone,
  setAlertSummaryFields
}) {
  (0, _react.useEffect)(() => {
    const alertSummaryFields = [{
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.pages.alertDetails.alertSummary.actualValue",
        defaultMessage: "Actual value"
      }),
      value: (0, _public.formatAlertEvaluationValue)(alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID], alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE])
    }, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.pages.alertDetails.alertSummary.expectedValue",
        defaultMessage: "Expected value"
      }),
      value: (0, _public.formatAlertEvaluationValue)(alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID], alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_EVALUATION_THRESHOLD])
    }, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.pages.alertDetails.alertSummary.serviceEnv",
        defaultMessage: "Service environment"
      }),
      value: alert === null || alert === void 0 ? void 0 : alert.fields[_apm.SERVICE_ENVIRONMENT]
    }, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.pages.alertDetails.alertSummary.serviceName",
        defaultMessage: "Service name"
      }),
      value: alert === null || alert === void 0 ? void 0 : alert.fields[_types.SERVICE_NAME]
    }];
    setAlertSummaryFields(alertSummaryFields);
  }, [alert === null || alert === void 0 ? void 0 : alert.fields, setAlertSummaryFields]);
  const params = rule.params;
  const environment = alert.fields[_apm.SERVICE_ENVIRONMENT];
  const latencyAggregationType = (0, _helpers.getAggsTypeFromRule)(params.aggregationType);

  // duration is us, convert it to MS
  const alertDurationMS = alert.fields[_ruleDataUtils.ALERT_DURATION] / 1000;
  const serviceName = String(alert.fields[_types.SERVICE_NAME]);

  // Currently, we don't use comparisonEnabled nor offset.
  // But providing them as they are required for the chart.
  const comparisonEnabled = false;
  const offset = '1d';
  const ruleWindowSizeMS = _moment.default.duration(rule.params.windowSize, rule.params.windowUnit).asMilliseconds();
  const TWENTY_TIMES_RULE_WINDOW_MS = 20 * ruleWindowSizeMS;
  /**
   * This is part or the requirements (RFC).
   * If the alert is less than 20 units of `FOR THE LAST <x> <units>` then we should draw a time range of 20 units.
   * IE. The user set "FOR THE LAST 5 minutes" at a minimum we should show 100 minutes.
   */
  const rangeFrom = alertDurationMS < TWENTY_TIMES_RULE_WINDOW_MS ? (0, _moment.default)(alert.start).subtract(TWENTY_TIMES_RULE_WINDOW_MS, 'millisecond').toISOString() : (0, _moment.default)(alert.start).subtract(ruleWindowSizeMS, 'millisecond').toISOString();
  const rangeTo = alert.active ?
  // Add one minute to chart range to ensure that the active alert annotation is shown when seconds are involved.
  (0, _moment.default)().add(1, 'minute').toISOString() : (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]).add(ruleWindowSizeMS, 'millisecond').toISOString();
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const transactionType = alert.fields[_types.TRANSACTION_TYPE];
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const {
    services: {
      uiSettings
    }
  } = (0, _public2.useKibana)();
  const historicalRange = (0, _react.useMemo)(() => {
    return {
      start: (0, _moment.default)().subtract(30, 'days').toISOString(),
      end: (0, _moment.default)().toISOString()
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_time_range_metadata_context.TimeRangeMetadataContextProvider, {
    start: start,
    end: end,
    kuery: "",
    useSpanName: false,
    uiSettings: uiSettings
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_latency_chart.default, {
    alert: alert,
    transactionType: transactionType,
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end,
    comparisonChartTheme: comparisonChartTheme,
    timeZone: timeZone,
    latencyAggregationType: latencyAggregationType,
    comparisonEnabled: comparisonEnabled,
    offset: offset
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_throughput_chart.default, {
    transactionType: transactionType,
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end,
    comparisonChartTheme: comparisonChartTheme,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    timeZone: timeZone
  }), /*#__PURE__*/_react.default.createElement(_failed_transaction_chart.default, {
    transactionType: transactionType,
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end,
    comparisonChartTheme: comparisonChartTheme,
    timeZone: timeZone
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_latency_alerts_history_chart.LatencyAlertsHistoryChart, {
    ruleId: alert.fields[_ruleDataUtils.ALERT_RULE_UUID],
    serviceName: serviceName,
    start: historicalRange.start,
    end: historicalRange.end,
    transactionType: transactionType,
    latencyAggregationType: latencyAggregationType,
    environment: environment,
    timeZone: timeZone
  })))));
}

// eslint-disable-next-line import/no-default-export
var _default = AlertDetailsAppSection;
exports.default = _default;