"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_fetcher = require("../../../../hooks/use_fetcher");
var get_timeseries_color = _interopRequireWildcard(require("../../../shared/charts/helper/get_timeseries_color"));
var _failed_transaction_rate_chart = require("../../../shared/charts/failed_transaction_rate_chart");
var _timeseries_chart = require("../../../shared/charts/timeseries_chart");
var _helpers = require("./helpers");
var _use_preferred_data_source_and_bucket_size = require("../../../../hooks/use_preferred_data_source_and_bucket_size");
var _document_type = require("../../../../../common/document_type");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* Error Rate */

const INITIAL_STATE_ERROR_RATE = {
  currentPeriod: {
    timeseries: [],
    average: null
  },
  previousPeriod: {
    timeseries: [],
    average: null
  }
};
function FailedTransactionChart({
  transactionType,
  serviceName,
  environment,
  start,
  end,
  comparisonChartTheme,
  timeZone
}) {
  const {
    currentPeriodColor: currentPeriodColorErrorRate
  } = get_timeseries_color.getTimeSeriesColor(get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE);
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery: '',
    numBuckets: 100,
    type: _document_type.ApmDocumentType.ServiceTransactionMetric
  });
  const {
    data: dataErrorRate = INITIAL_STATE_ERROR_RATE,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (transactionType && serviceName && start && end && preferred) {
      return callApmApi('GET /internal/apm/services/{serviceName}/transactions/charts/error_rate', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery: '',
            start,
            end,
            transactionType,
            transactionName: undefined,
            documentType: preferred.source.documentType,
            rollupInterval: preferred.source.rollupInterval,
            bucketSizeInSeconds: preferred.bucketSizeInSeconds
          }
        }
      });
    }
  }, [environment, serviceName, start, end, transactionType, preferred]);
  const timeseriesErrorRate = [{
    data: dataErrorRate.currentPeriod.timeseries,
    type: 'linemark',
    color: currentPeriodColorErrorRate,
    title: _i18n.i18n.translate('xpack.apm.errorRate.chart.errorRate', {
      defaultMessage: 'Failed transaction rate (avg.)'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.errorRate', {
    defaultMessage: 'Failed transaction rate'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _failed_transaction_rate_chart.errorRateI18n,
    position: "right"
  }))), /*#__PURE__*/_react.default.createElement(_timeseries_chart.TimeseriesChart, {
    id: "errorRate",
    height: 200,
    showAnnotations: false,
    fetchStatus: status,
    timeseries: timeseriesErrorRate,
    yLabelFormat: _helpers.yLabelFormat,
    yDomain: {
      min: 0,
      max: 1
    },
    comparisonEnabled: false,
    customTheme: comparisonChartTheme,
    timeZone: timeZone
  })));
}

// eslint-disable-next-line import/no-default-export
var _default = FailedTransactionChart;
exports.default = _default;
module.exports = exports.default;