"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionErrorRateRuleType = TransactionErrorRateRuleType;
exports.default = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _formatters = require("../../../../../common/utils/formatters");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _chart_preview = require("../../ui_components/chart_preview");
var _fields = require("../../utils/fields");
var _helper = require("../../utils/helper");
var _apm_rule_params_container = require("../../ui_components/apm_rule_params_container");
var _apm_rule_group_by = require("../../ui_components/apm_rule_group_by");
var _apm = require("../../../../../common/es_fields/apm");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionErrorRateRuleType(props) {
  var _params$threshold, _data$errorRateChartP;
  const {
    services
  } = (0, _public.useKibana)();
  const {
    ruleParams,
    metadata,
    setRuleParams,
    setRuleProperty
  } = props;
  (0, _react.useEffect)(() => {
    (0, _create_call_apm_api.createCallApmApi)(services);
  }, [services]);
  const params = (0, _lodash.defaults)({
    ...(0, _lodash.omit)(metadata, ['start', 'end']),
    ...ruleParams
  }, {
    threshold: 30,
    windowSize: 5,
    windowUnit: _public2.TIME_UNITS.MINUTE,
    environment: _environment_filter_values.ENVIRONMENT_ALL.value
  });
  const thresholdAsPercent = ((_params$threshold = params.threshold) !== null && _params$threshold !== void 0 ? _params$threshold : 0) / 100;
  const {
    data
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    const {
      interval,
      start,
      end
    } = (0, _helper.getIntervalAndTimeRange)({
      windowSize: params.windowSize,
      windowUnit: params.windowUnit
    });
    if (interval && start && end) {
      return callApmApi('GET /internal/apm/rule_types/transaction_error_rate/chart_preview', {
        params: {
          query: {
            environment: params.environment,
            serviceName: params.serviceName,
            transactionType: params.transactionType,
            transactionName: params.transactionName,
            interval,
            start,
            end
          }
        }
      });
    }
  }, [params.transactionType, params.transactionName, params.environment, params.serviceName, params.windowSize, params.windowUnit]);
  const onGroupByChange = (0, _react.useCallback)(group => {
    setRuleParams('groupBy', group !== null && group !== void 0 ? group : []);
  }, [setRuleParams]);
  const fields = [/*#__PURE__*/_react.default.createElement(_fields.ServiceField, {
    currentValue: params.serviceName,
    onChange: value => {
      if (value !== params.serviceName) {
        setRuleParams('serviceName', value);
        setRuleParams('transactionType', undefined);
        setRuleParams('transactionName', undefined);
        setRuleParams('environment', _environment_filter_values.ENVIRONMENT_ALL.value);
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.TransactionTypeField, {
    currentValue: params.transactionType,
    onChange: value => setRuleParams('transactionType', value),
    serviceName: params.serviceName
  }), /*#__PURE__*/_react.default.createElement(_fields.EnvironmentField, {
    currentValue: params.environment,
    onChange: value => setRuleParams('environment', value !== '' ? value : _environment_filter_values.ENVIRONMENT_ALL.value),
    serviceName: params.serviceName
  }), /*#__PURE__*/_react.default.createElement(_fields.TransactionNameField, {
    currentValue: params.transactionName,
    onChange: value => setRuleParams('transactionName', value),
    serviceName: params.serviceName
  }), /*#__PURE__*/_react.default.createElement(_fields.IsAboveField, {
    value: params.threshold,
    unit: "%",
    onChange: value => setRuleParams('threshold', value || 0)
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    onChangeWindowSize: timeWindowSize => setRuleParams('windowSize', timeWindowSize || ''),
    onChangeWindowUnit: timeWindowUnit => setRuleParams('windowUnit', timeWindowUnit),
    timeWindowSize: params.windowSize,
    timeWindowUnit: params.windowUnit,
    errors: {
      timeWindowSize: [],
      timeWindowUnit: []
    }
  })];

  // hide preview chart until https://github.com/elastic/kibana/pull/156625 gets merged
  const showChartPreview = false;
  const chartPreview = showChartPreview ? /*#__PURE__*/_react.default.createElement(_chart_preview.ChartPreview, {
    series: [{
      data: (_data$errorRateChartP = data === null || data === void 0 ? void 0 : data.errorRateChartPreview) !== null && _data$errorRateChartP !== void 0 ? _data$errorRateChartP : []
    }],
    yTickFormat: d => (0, _formatters.asPercent)(d, 1),
    threshold: thresholdAsPercent,
    uiSettings: services.uiSettings
  }) : null;
  const groupAlertsBy = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.ruleFlyout.errorRate.createAlertPerText', {
      defaultMessage: 'Group alerts by'
    }),
    helpText: _i18n.i18n.translate('xpack.apm.ruleFlyout.errorRate.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "transaction.name". By default, alert is created for every unique service.name, service.environment and transaction.type.'
    }),
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_apm_rule_group_by.APMRuleGroupBy, {
    onChange: onGroupByChange,
    options: {
      groupBy: ruleParams.groupBy
    },
    fields: [_apm.TRANSACTION_NAME],
    preSelectedOptions: [_apm.SERVICE_NAME, _apm.SERVICE_ENVIRONMENT, _apm.TRANSACTION_TYPE]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
  return /*#__PURE__*/_react.default.createElement(_apm_rule_params_container.ApmRuleParamsContainer, {
    minimumWindowSize: {
      value: 5,
      unit: _public2.TIME_UNITS.MINUTE
    },
    fields: fields,
    groupAlertsBy: groupAlertsBy,
    defaultParams: params,
    setRuleParams: setRuleParams,
    setRuleProperty: setRuleProperty,
    chartPreview: chartPreview
  });
}

// Default export is required for React.lazy loading
//
// eslint-disable-next-line import/no-default-export
var _default = TransactionErrorRateRuleType;
exports.default = _default;