"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerApmRuleTypes = registerApmRuleTypes;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _formatters = require("../../../../common/utils/formatters");
var _apm_rule_types = require("../../../../common/rules/apm_rule_types");
var _default_action_message = require("../../../../common/rules/default_action_message");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// copied from elasticsearch_fieldnames.ts to limit page load bundle size
const SERVICE_ENVIRONMENT = 'service.environment';
const SERVICE_NAME = 'service.name';
const TRANSACTION_TYPE = 'transaction.type';
function registerApmRuleTypes(observabilityRuleTypeRegistry) {
  observabilityRuleTypeRegistry.register({
    id: _apm_rule_types.ApmRuleType.ErrorCount,
    description: _i18n.i18n.translate('xpack.apm.alertTypes.errorCount.description', {
      defaultMessage: 'Alert when the number of errors in a service exceeds a defined threshold.'
    }),
    format: ({
      fields
    }) => {
      return {
        reason: fields[_ruleDataUtils.ALERT_REASON],
        link: (0, _formatters.getAlertUrlErrorCount)(
        // TODO:fix SERVICE_NAME when we move it to initializeIndex
        String(fields[SERVICE_NAME][0]), fields[SERVICE_ENVIRONMENT] && String(fields[SERVICE_ENVIRONMENT][0]))
      };
    },
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.alerting.apmRules}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./error_count_rule_type')))),
    validate: () => ({
      errors: []
    }),
    requiresAppContext: false,
    defaultActionMessage: _default_action_message.errorCountMessage
  });
  observabilityRuleTypeRegistry.register({
    id: _apm_rule_types.ApmRuleType.TransactionDuration,
    description: _i18n.i18n.translate('xpack.apm.alertTypes.transactionDuration.description', {
      defaultMessage: 'Alert when the latency of a specific transaction type in a service exceeds a defined threshold.'
    }),
    format: ({
      fields
    }) => {
      return {
        reason: fields[_ruleDataUtils.ALERT_REASON],
        link: (0, _formatters.getAlertUrlTransaction)(
        // TODO:fix SERVICE_NAME when we move it to initializeIndex
        String(fields[SERVICE_NAME][0]), fields[SERVICE_ENVIRONMENT] && String(fields[SERVICE_ENVIRONMENT][0]), String(fields[TRANSACTION_TYPE][0]))
      };
    },
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.alerting.apmRules}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./transaction_duration_rule_type')))),
    validate: () => ({
      errors: []
    }),
    alertDetailsAppSection: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../ui_components/alert_details_app_section')))),
    requiresAppContext: false,
    defaultActionMessage: _default_action_message.transactionDurationMessage
  });
  observabilityRuleTypeRegistry.register({
    id: _apm_rule_types.ApmRuleType.TransactionErrorRate,
    description: _i18n.i18n.translate('xpack.apm.alertTypes.transactionErrorRate.description', {
      defaultMessage: 'Alert when the rate of transaction errors in a service exceeds a defined threshold.'
    }),
    format: ({
      fields
    }) => ({
      reason: fields[_ruleDataUtils.ALERT_REASON],
      link: (0, _formatters.getAlertUrlTransaction)(
      // TODO:fix SERVICE_NAME when we move it to initializeIndex
      String(fields[SERVICE_NAME][0]), fields[SERVICE_ENVIRONMENT] && String(fields[SERVICE_ENVIRONMENT][0]), String(fields[TRANSACTION_TYPE][0]))
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.alerting.apmRules}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./transaction_error_rate_rule_type')))),
    validate: () => ({
      errors: []
    }),
    requiresAppContext: false,
    defaultActionMessage: _default_action_message.transactionErrorRateMessage
  });
  observabilityRuleTypeRegistry.register({
    id: _apm_rule_types.ApmRuleType.Anomaly,
    description: _i18n.i18n.translate('xpack.apm.alertTypes.anomaly.description', {
      defaultMessage: 'Alert when either the latency, throughput, or failed transaction rate of a service is anomalous.'
    }),
    format: ({
      fields
    }) => ({
      reason: fields[_ruleDataUtils.ALERT_REASON],
      link: (0, _formatters.getAlertUrlTransaction)(
      // TODO:fix SERVICE_NAME when we move it to initializeIndex
      String(fields[SERVICE_NAME][0]), fields[SERVICE_ENVIRONMENT] && String(fields[SERVICE_ENVIRONMENT][0]), String(fields[TRANSACTION_TYPE][0]))
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.alerting.apmRules}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./transaction_duration_anomaly_rule_type')))),
    validate: () => ({
      errors: []
    }),
    requiresAppContext: false,
    defaultActionMessage: _default_action_message.anomalyMessage
  });
}