"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transactionErrorRateMessage = exports.transactionDurationMessage = exports.errorCountMessage = exports.anomalyMessage = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorCountMessage = _i18n.i18n.translate('xpack.apm.alertTypes.errorCount.defaultActionMessage', {
  defaultMessage: `\\{\\{alertName\\}\\} alert is firing because of the following conditions:

- Service name: \\{\\{context.serviceName\\}\\}
- Environment: \\{\\{context.environment\\}\\}
- Threshold: \\{\\{context.threshold\\}\\}
- Triggered value: \\{\\{context.triggerValue\\}\\} errors over the last \\{\\{context.interval\\}\\}`
});
exports.errorCountMessage = errorCountMessage;
const transactionDurationMessage = _i18n.i18n.translate('xpack.apm.alertTypes.transactionDuration.defaultActionMessage', {
  defaultMessage: `\\{\\{alertName\\}\\} alert is firing because of the following conditions:

- Service name: \\{\\{context.serviceName\\}\\}
- Transaction type: \\{\\{context.transactionType\\}\\}
- Transaction name: \\{\\{context.transactionName\\}\\}
- Environment: \\{\\{context.environment\\}\\}
- Latency threshold: \\{\\{context.threshold\\}\\}ms
- Latency observed: \\{\\{context.triggerValue\\}\\} over the last \\{\\{context.interval\\}\\}`
});
exports.transactionDurationMessage = transactionDurationMessage;
const transactionErrorRateMessage = _i18n.i18n.translate('xpack.apm.alertTypes.transactionErrorRate.defaultActionMessage', {
  defaultMessage: `\\{\\{alertName\\}\\} alert is firing because of the following conditions:

- Service name: \\{\\{context.serviceName\\}\\}
- Type: \\{\\{context.transactionType\\}\\}
- Environment: \\{\\{context.environment\\}\\}
- Threshold: \\{\\{context.threshold\\}\\}%
- Triggered value: \\{\\{context.triggerValue\\}\\}% of errors over the last \\{\\{context.interval\\}\\}`
});
exports.transactionErrorRateMessage = transactionErrorRateMessage;
const anomalyMessage = _i18n.i18n.translate('xpack.apm.alertTypes.transactionDurationAnomaly.defaultActionMessage', {
  defaultMessage: `\\{\\{alertName\\}\\} alert is firing because of the following conditions:

- Service name: \\{\\{context.serviceName\\}\\}
- Type: \\{\\{context.transactionType\\}\\}
- Environment: \\{\\{context.environment\\}\\}
- Severity threshold: \\{\\{context.threshold\\}\\}
- Severity value: \\{\\{context.triggerValue\\}\\}
`
});
exports.anomalyMessage = anomalyMessage;