"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unifiedSearchBarPlaceholder = exports.getSearchBarBoolFilter = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("./es_fields/apm");
var _environment_query = require("./utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unifiedSearchBarPlaceholder = _i18n.i18n.translate('xpack.apm.dependencies.unifiedSearchBarPlaceholder', {
  defaultMessage: `Search dependency metrics (e.g. span.destination.service.resource:elasticsearch)`
});
exports.unifiedSearchBarPlaceholder = unifiedSearchBarPlaceholder;
const getSearchBarBoolFilter = ({
  dependencyName,
  environment
}) => {
  return [{
    term: {
      [_apm.PROCESSOR_EVENT]: _common.ProcessorEvent.metric
    }
  }, {
    exists: {
      field: _apm.SPAN_DESTINATION_SERVICE_RESOURCE
    }
  }, ...(dependencyName ? [{
    term: {
      [_apm.SPAN_DESTINATION_SERVICE_RESOURCE]: dependencyName
    }
  }] : []), ...(0, _environment_query.environmentQuery)(environment)];
};
exports.getSearchBarBoolFilter = getSearchBarBoolFilter;