"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrappedStateRt = exports.alertTypeStateRt = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const trackedAlertStateRt = t.type({
  alertId: t.string,
  alertUuid: t.string,
  started: t.string,
  // an array used to track changes in alert state, the order is based on the rule executions
  // true - alert has changed from active/recovered
  // false - alert is new or the status has remained either active or recovered
  flappingHistory: t.array(t.boolean),
  // flapping flag that indicates whether the alert is flapping
  flapping: t.boolean,
  pendingRecoveredCount: t.number
});
const alertTypeStateRt = () => t.record(t.string, t.unknown);
exports.alertTypeStateRt = alertTypeStateRt;
const wrappedStateRt = () => t.type({
  wrapped: alertTypeStateRt(),
  // tracks the active alerts
  trackedAlerts: t.record(t.string, trackedAlertStateRt),
  // tracks the recovered alerts
  trackedAlertsRecovered: t.record(t.string, trackedAlertStateRt)
});

/**
 * This is redefined instead of derived from above `wrappedStateRt` because
 * there's no easy way to instantiate generic values such as the runtime type
 * factory function.
 */
exports.wrappedStateRt = wrappedStateRt;