"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.throttledActionSchema = exports.rawAlertInstance = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _date_from_string = require("./date_from_string");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionSchema = t.type({
  date: _date_from_string.DateFromString
});
const throttledActionSchema = t.record(t.string, actionSchema);
exports.throttledActionSchema = throttledActionSchema;
const lastScheduledActionsSchema = t.intersection([t.partial({
  subgroup: t.string
}), t.type({
  group: t.string,
  date: _date_from_string.DateFromString
}), t.partial({
  actions: throttledActionSchema
})]);
const metaSchema = t.partial({
  lastScheduledActions: lastScheduledActionsSchema,
  // an array used to track changes in alert state, the order is based on the rule executions (oldest to most recent)
  // true - alert has changed from active/recovered
  // false - the status has remained either active or recovered
  flappingHistory: t.array(t.boolean),
  // flapping flag that indicates whether the alert is flapping
  flapping: t.boolean,
  maintenanceWindowIds: t.array(t.string),
  pendingRecoveredCount: t.number,
  uuid: t.string
});
const stateSchema = t.record(t.string, t.unknown);
const contextSchema = t.record(t.string, t.unknown);
const rawAlertInstance = t.partial({
  state: stateSchema,
  meta: metaSchema
});
exports.rawAlertInstance = rawAlertInstance;