"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertWithAnyUUID = alertWithAnyUUID;
exports.alertsWithAnyUUID = alertsWithAnyUUID;
exports.resolvable = resolvable;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a promise which can be resolved externally, useful for
 * coordinating async tests.
 */
function resolvable() {
  let resolve;
  return Object.assign(new Promise(r => resolve = r), {
    resolve(arg) {
      return setTimeout(() => resolve(arg), 0);
    }
  });
}

// Used to convert a raw Rule's UUID to something that can be used
// to compare with a jest snapshot.
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function alertWithAnyUUID(rawAlert) {
  var _rawAlert$meta;
  if (!(rawAlert !== null && rawAlert !== void 0 && (_rawAlert$meta = rawAlert.meta) !== null && _rawAlert$meta !== void 0 && _rawAlert$meta.uuid)) return rawAlert;
  const newAlert = JSON.parse(JSON.stringify(rawAlert));
  newAlert.meta.uuid = expect.any(String);
  return newAlert;
}
function alertsWithAnyUUID(
// eslint-disable-next-line @typescript-eslint/no-explicit-any
rawAlerts) {
  const newAlerts = {};
  for (const id of Object.keys(rawAlerts)) {
    newAlerts[id] = alertWithAnyUUID(rawAlerts[id]);
  }
  return newAlerts;
}