"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rulesSettingsFeature = void 0;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rulesSettingsFeature = {
  id: _common.RULES_SETTINGS_FEATURE_ID,
  name: _i18n.i18n.translate('xpack.alerting.feature.rulesSettingsFeatureName', {
    defaultMessage: 'Rules Settings'
  }),
  category: _server.DEFAULT_APP_CATEGORIES.management,
  app: [],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  privileges: {
    all: {
      app: [],
      api: [],
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      savedObject: {
        all: [_common.RULES_SETTINGS_SAVED_OBJECT_TYPE],
        read: []
      },
      ui: ['show', 'save']
    },
    read: {
      app: [],
      api: [],
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      savedObject: {
        all: [],
        read: [_common.RULES_SETTINGS_SAVED_OBJECT_TYPE]
      },
      ui: ['show']
    }
  },
  subFeatures: [{
    name: _i18n.i18n.translate('xpack.alerting.feature.flappingSettingsSubFeatureName', {
      defaultMessage: 'Flapping detection'
    }),
    privilegeGroups: [{
      groupType: 'mutually_exclusive',
      privileges: [{
        api: [_common.API_PRIVILEGES.READ_FLAPPING_SETTINGS, _common.API_PRIVILEGES.WRITE_FLAPPING_SETTINGS],
        name: 'All',
        id: _common.ALL_FLAPPING_SETTINGS_SUB_FEATURE_ID,
        includeIn: 'all',
        savedObject: {
          all: [_common.RULES_SETTINGS_SAVED_OBJECT_TYPE],
          read: []
        },
        ui: ['writeFlappingSettingsUI', 'readFlappingSettingsUI']
      }, {
        api: [_common.API_PRIVILEGES.READ_FLAPPING_SETTINGS],
        name: 'Read',
        id: _common.READ_FLAPPING_SETTINGS_SUB_FEATURE_ID,
        includeIn: 'read',
        savedObject: {
          all: [],
          read: [_common.RULES_SETTINGS_SAVED_OBJECT_TYPE]
        },
        ui: ['readFlappingSettingsUI']
      }]
    }]
  }]
};
exports.rulesSettingsFeature = rulesSettingsFeature;