"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _rules_settings_flapping_client = require("./flapping/rules_settings_flapping_client");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RulesSettingsClient {
  constructor(options) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsClient", void 0);
    (0, _defineProperty2.default)(this, "getUserName", void 0);
    (0, _defineProperty2.default)(this, "_flapping", void 0);
    this.logger = options.logger;
    this.savedObjectsClient = options.savedObjectsClient;
    this.getUserName = options.getUserName;
    this._flapping = new _rules_settings_flapping_client.RulesSettingsFlappingClient({
      logger: this.logger,
      savedObjectsClient: this.savedObjectsClient,
      getOrCreate: this.getOrCreate.bind(this),
      getModificationMetadata: this.getModificationMetadata.bind(this)
    });
  }
  async getModificationMetadata() {
    const createTime = Date.now();
    const userName = await this.getUserName();
    return {
      createdBy: userName,
      updatedBy: userName,
      createdAt: new Date(createTime).toISOString(),
      updatedAt: new Date(createTime).toISOString()
    };
  }
  async get() {
    try {
      return await this.savedObjectsClient.get(_common.RULES_SETTINGS_SAVED_OBJECT_TYPE, _common.RULES_SETTINGS_SAVED_OBJECT_ID);
    } catch (e) {
      this.logger.error(`Failed to get rules setting for current space. Error: ${e}`);
      throw e;
    }
  }
  async create() {
    const modificationMetadata = await this.getModificationMetadata();
    try {
      return await this.savedObjectsClient.create(_common.RULES_SETTINGS_SAVED_OBJECT_TYPE, {
        flapping: {
          ..._common.DEFAULT_FLAPPING_SETTINGS,
          ...modificationMetadata
        }
      }, {
        id: _common.RULES_SETTINGS_SAVED_OBJECT_ID,
        overwrite: true
      });
    } catch (e) {
      this.logger.error(`Failed to create rules setting for current space. Error: ${e}`);
      throw e;
    }
  }

  /**
   * Helper function to ensure that a rules-settings saved object always exists.
   * Ensures the creation of the saved object is done lazily during retrieval.
   */
  async getOrCreate() {
    try {
      return await this.get();
    } catch (e) {
      if (_server.SavedObjectsErrorHelpers.isNotFoundError(e)) {
        this.logger.info('Creating new default rules settings for current space.');
        return await this.create();
      }
      this.logger.error(`Failed to persist rules setting for current space. Error: ${e}`);
      throw e;
    }
  }
  flapping() {
    return this._flapping;
  }
}
exports.RulesSettingsClient = RulesSettingsClient;