"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertState = getAlertState;
var _alert_task_instance = require("../../task_runner/alert_task_instance");
var _authorization = require("../../authorization");
var _get = require("./get");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAlertState(context, {
  id
}) {
  const alert = await (0, _get.get)(context, {
    id
  });
  await context.authorization.ensureAuthorized({
    ruleTypeId: alert.alertTypeId,
    consumer: alert.consumer,
    operation: _authorization.ReadOperations.GetRuleState,
    entity: _authorization.AlertingAuthorizationEntity.Rule
  });
  if (alert.scheduledTaskId) {
    const {
      state
    } = (0, _alert_task_instance.taskInstanceToAlertTaskInstance)(await context.taskManager.get(alert.scheduledTaskId), alert);
    return state;
  }
}