"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearExpiredSnoozes = clearExpiredSnoozes;
var _saved_objects = require("../../saved_objects");
var _lib = require("../../lib");
var _lib2 = require("../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function clearExpiredSnoozes(context, {
  id
}) {
  var _attributes$snoozeSch;
  const {
    attributes,
    version
  } = await context.unsecuredSavedObjectsClient.get('alert', id);
  const snoozeSchedule = attributes.snoozeSchedule ? attributes.snoozeSchedule.filter(s => {
    try {
      return !(0, _lib.isSnoozeExpired)(s);
    } catch (e) {
      context.logger.error(`Error checking for expiration of snooze ${s.id}: ${e}`);
      return true;
    }
  }) : [];
  if (snoozeSchedule.length === ((_attributes$snoozeSch = attributes.snoozeSchedule) === null || _attributes$snoozeSch === void 0 ? void 0 : _attributes$snoozeSch.length)) return;
  const updateAttributes = (0, _lib2.updateMeta)(context, {
    snoozeSchedule,
    updatedBy: await context.getUserName(),
    updatedAt: new Date().toISOString()
  });
  const updateOptions = {
    version
  };
  await (0, _saved_objects.partiallyUpdateAlert)(context.unsecuredSavedObjectsClient, id, updateAttributes, updateOptions);
}