"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.activeMaintenanceWindowsRoute = void 0;
var _lib = require("../lib");
var _types = require("../../types");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const activeMaintenanceWindowsRoute = (router, licenseState) => {
  router.get({
    path: _types.INTERNAL_ALERTING_API_GET_ACTIVE_MAINTENANCE_WINDOWS_PATH,
    validate: {},
    options: {
      tags: [`access:${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.READ_MAINTENANCE_WINDOW}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    // We do not want to throw for this route because other solutions
    // will be using it to determine whether or not they should
    // display a callout in their rules list.
    try {
      licenseState.ensureLicenseForMaintenanceWindow();
    } catch (e) {
      return res.ok({
        body: []
      });
    }
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const result = await maintenanceWindowClient.getActiveMaintenanceWindows();
    return res.ok({
      body: result.map(maintenanceWindow => (0, _lib.rewriteMaintenanceWindowRes)(maintenanceWindow))
    });
  })));
};
exports.activeMaintenanceWindowsRoute = activeMaintenanceWindowsRoute;