"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleTagsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../common");
var _types = require("../types");
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const querySchema = _configSchema.schema.object({
  filter: _configSchema.schema.maybe(_configSchema.schema.string()),
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  after: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()])))),
  max_tags: _configSchema.schema.maybe(_configSchema.schema.number())
});
const rewriteQueryReq = ({
  max_tags: maxTags,
  ...rest
}) => ({
  ...rest,
  ...(maxTags ? {
    maxTags
  } : {})
});
const rewriteBodyRes = ({
  ruleTags,
  ...rest
}) => ({
  ...rest,
  rule_tags: ruleTags
});
const getRuleTagsRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/_tags`,
    validate: {
      query: querySchema
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const options = rewriteQueryReq(req.query);
    const aggregateResult = await rulesClient.aggregate({
      options: {
        ...options,
        defaultSearchOperator: 'AND',
        searchFields: ['tags']
      },
      aggs: (0, _common.getRuleTagsAggregation)({
        maxTags: options.maxTags,
        after: options.after
      })
    });
    return res.ok({
      body: rewriteBodyRes((0, _common.formatRuleTagsAggregationResult)(aggregateResult))
    });
  })));
};
exports.getRuleTagsRoute = getRuleTagsRoute;