"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleResultService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleResultService {
  constructor() {
    (0, _defineProperty2.default)(this, "errors", []);
    (0, _defineProperty2.default)(this, "warnings", []);
    (0, _defineProperty2.default)(this, "outcomeMessage", '');
  }
  getLastRunErrors() {
    return this.errors;
  }
  getLastRunWarnings() {
    return this.warnings;
  }
  getLastRunOutcomeMessage() {
    return this.outcomeMessage;
  }
  getLastRunResults() {
    return {
      errors: this.errors,
      warnings: this.warnings,
      outcomeMessage: this.outcomeMessage
    };
  }
  getLastRunSetters() {
    return {
      addLastRunError: this.addLastRunError.bind(this),
      addLastRunWarning: this.addLastRunWarning.bind(this),
      setLastRunOutcomeMessage: this.setLastRunOutcomeMessage.bind(this)
    };
  }
  addLastRunError(error) {
    this.errors.push(error);
  }
  addLastRunWarning(warning) {
    this.warnings.push(warning);
  }
  setLastRunOutcomeMessage(outcomeMessage) {
    this.outcomeMessage = outcomeMessage;
  }
}
exports.RuleResultService = RuleResultService;